/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.api.BatchExtension;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputPath;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.issue.Issuable;
import org.sonar.api.issue.Issue;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.source.Highlightable;
import org.sonar.api.source.Symbolizable;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.java.JavaClasspath;
import org.sonar.java.JavaTestClasspath;
import org.sonar.plugins.java.api.CheckRegistrar;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.squidbridge.annotations.SqaleLinearRemediation;
import org.sonar.squidbridge.annotations.SqaleLinearWithOffsetRemediation;
import org.sonar.squidbridge.api.CodeVisitor;

public class SonarComponents
implements BatchExtension {
    private final FileLinesContextFactory fileLinesContextFactory;
    private final ResourcePerspectives resourcePerspectives;
    private final JavaTestClasspath javaTestClasspath;
    private final CheckFactory checkFactory;
    private final FileSystem fs;
    private final JavaClasspath javaClasspath;
    private final List<Checks<JavaCheck>> checks;
    private final List<Checks<JavaCheck>> testChecks;

    public SonarComponents(FileLinesContextFactory fileLinesContextFactory, ResourcePerspectives resourcePerspectives, FileSystem fs, JavaClasspath javaClasspath, JavaTestClasspath javaTestClasspath, CheckFactory checkFactory) {
        this(fileLinesContextFactory, resourcePerspectives, fs, javaClasspath, javaTestClasspath, checkFactory, null);
    }

    public SonarComponents(FileLinesContextFactory fileLinesContextFactory, ResourcePerspectives resourcePerspectives, FileSystem fs, JavaClasspath javaClasspath, JavaTestClasspath javaTestClasspath, CheckFactory checkFactory, @Nullable CheckRegistrar[] checkRegistrars) {
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.resourcePerspectives = resourcePerspectives;
        this.fs = fs;
        this.javaClasspath = javaClasspath;
        this.javaTestClasspath = javaTestClasspath;
        this.checkFactory = checkFactory;
        this.checks = Lists.newArrayList();
        this.testChecks = Lists.newArrayList();
        if (checkRegistrars != null) {
            CheckRegistrar.RegistrarContext registrarContext = new CheckRegistrar.RegistrarContext();
            for (CheckRegistrar checkClassesRegister : checkRegistrars) {
                checkClassesRegister.register(registrarContext);
                ArrayList checkClasses = registrarContext.checkClasses();
                ArrayList testCheckClasses = registrarContext.testCheckClasses();
                this.registerCheckClasses(registrarContext.repositoryKey(), Lists.newArrayList((Iterable)(checkClasses != null ? checkClasses : new ArrayList())));
                this.registerTestCheckClasses(registrarContext.repositoryKey(), Lists.newArrayList((Iterable)(testCheckClasses != null ? testCheckClasses : new ArrayList())));
            }
        }
    }

    public InputFile inputFromIOFile(File file) {
        return this.fs.inputFile(this.fs.predicates().is(file));
    }

    private InputPath inputPathFromIOFile(File file) {
        if (file.isDirectory()) {
            return this.fs.inputDir(file);
        }
        return this.inputFromIOFile(file);
    }

    public FileLinesContext fileLinesContextFor(File file) {
        return this.fileLinesContextFactory.createFor(this.inputFromIOFile(file));
    }

    public Symbolizable symbolizableFor(File file) {
        return (Symbolizable)this.resourcePerspectives.as(Symbolizable.class, (InputPath)this.inputFromIOFile(file));
    }

    public Highlightable highlightableFor(File file) {
        return (Highlightable)this.resourcePerspectives.as(Highlightable.class, (InputPath)this.inputFromIOFile(file));
    }

    public Issuable issuableFor(File file) {
        return (Issuable)this.resourcePerspectives.as(Issuable.class, this.inputPathFromIOFile(file));
    }

    public List<File> getJavaClasspath() {
        if (this.javaClasspath == null) {
            return Lists.newArrayList();
        }
        return this.javaClasspath.getElements();
    }

    public List<File> getJavaTestClasspath() {
        return this.javaTestClasspath.getElements();
    }

    public ResourcePerspectives getResourcePerspectives() {
        return this.resourcePerspectives;
    }

    public void registerCheckClasses(String repositoryKey, List<Class<? extends JavaCheck>> checkClasses) {
        this.checks.add((Checks<JavaCheck>)this.checkFactory.create(repositoryKey).addAnnotatedChecks(checkClasses));
    }

    public CodeVisitor[] checkClasses() {
        ArrayList visitors = Lists.newArrayList();
        for (Checks<JavaCheck> checksElement : this.checks) {
            Collection checksCollection = checksElement.all();
            if (checksCollection.isEmpty()) continue;
            visitors.addAll(checksCollection);
        }
        return visitors.toArray(new CodeVisitor[visitors.size()]);
    }

    public Iterable<Checks<JavaCheck>> checks() {
        return Iterables.concat(this.checks, (Iterable)Lists.newArrayList(this.testChecks));
    }

    public void registerTestCheckClasses(String repositoryKey, List<Class<? extends JavaCheck>> checkClasses) {
        this.testChecks.add((Checks<JavaCheck>)this.checkFactory.create(repositoryKey).addAnnotatedChecks(checkClasses));
    }

    public Collection<JavaCheck> testCheckClasses() {
        ArrayList visitors = Lists.newArrayList();
        for (Checks<JavaCheck> checksElement : this.testChecks) {
            Collection checksCollection = checksElement.all();
            if (checksCollection.isEmpty()) continue;
            visitors.addAll(checksCollection);
        }
        return visitors;
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    public RuleKey getRuleKey(JavaCheck check) {
        for (Checks<JavaCheck> sonarChecks : this.checks()) {
            RuleKey ruleKey = sonarChecks.ruleKey((Object)check);
            if (ruleKey == null) continue;
            return ruleKey;
        }
        return null;
    }

    public void addIssue(File file, JavaCheck check, int line, String message, @Nullable Double cost) {
        Issuable issuable;
        Preconditions.checkNotNull((Object)check);
        Preconditions.checkNotNull((Object)message);
        RuleKey key = this.getRuleKey(check);
        if (key != null && (issuable = this.issuableFor(file)) != null) {
            Issuable.IssueBuilder issueBuilder = issuable.newIssueBuilder().ruleKey(key).message(message);
            if (line > -1) {
                issueBuilder.line(Integer.valueOf(line));
            }
            if (cost == null) {
                Annotation linear = AnnotationUtils.getAnnotation((Object)check, SqaleLinearRemediation.class);
                Annotation linearWithOffset = AnnotationUtils.getAnnotation((Object)check, SqaleLinearWithOffsetRemediation.class);
                if (linear != null || linearWithOffset != null) {
                    throw new IllegalStateException("A check annotated with a linear sqale function should provide an effort to fix");
                }
            } else {
                issueBuilder.effortToFix(cost);
            }
            Issue issue = issueBuilder.build();
            issuable.addIssue(issue);
        }
    }
}

