/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.cfg;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.ArrayDimensionTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.BreakStatementTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.ContinueStatementTree;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.LabeledStatementTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.SynchronizedStatementTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;

public class CFG {
    private final Block exitBlock;
    private final Symbol.MethodSymbol methodSymbol;
    private Block currentBlock;
    private final List<Block> blocks = new ArrayList<Block>();
    private final Deque<Block> breakTargets = new LinkedList<Block>();
    private final Deque<Block> continueTargets = new LinkedList<Block>();
    private final Deque<Block> switches = new LinkedList<Block>();
    private Map<String, Block> labels = Maps.newHashMap();
    private final List<Block> gotos = new LinkedList<Block>();

    public Symbol.MethodSymbol methodSymbol() {
        return this.methodSymbol;
    }

    public Block entry() {
        return this.currentBlock;
    }

    public List<Block> blocks() {
        return Lists.reverse(this.blocks);
    }

    public List<Block> reversedBlocks() {
        return this.blocks;
    }

    private CFG(BlockTree tree, Symbol.MethodSymbol symbol) {
        this.methodSymbol = symbol;
        this.exitBlock = this.createBlock();
        this.currentBlock = this.createBlock(this.exitBlock);
        for (StatementTree statementTree : Lists.reverse(tree.body())) {
            this.build(statementTree);
        }
        for (Block b : this.gotos) {
            assert (b.successors.isEmpty());
            Tree s = b.terminator;
            assert (s != null);
            String label = s.is(Tree.Kind.BREAK_STATEMENT) ? ((BreakStatementTree)s).label().name() : ((ContinueStatementTree)s).label().name();
            Block target = this.labels.get(label);
            if (target == null) {
                throw new IllegalStateException("Undeclared label: " + label);
            }
            b.successors.add(target);
        }
        for (Block b : this.blocks) {
            for (Block successor : b.successors) {
                successor.predecessors.add(b);
            }
        }
    }

    private Block createBlock(Block successor) {
        Block result = this.createBlock();
        result.successors.add(successor);
        return result;
    }

    private Block createBlock() {
        Block result = new Block(this.blocks.size());
        this.blocks.add(result);
        return result;
    }

    public static CFG build(MethodTree tree) {
        Preconditions.checkArgument((tree.block() != null ? 1 : 0) != 0, (Object)"Cannot build CFG for method with no body.");
        return new CFG(tree.block(), tree.symbol());
    }

    private void build(List<? extends Tree> trees) {
        for (Tree tree : Lists.reverse(trees)) {
            this.build(tree);
        }
    }

    private void build(Tree tree) {
        switch (tree.kind()) {
            case BLOCK: {
                this.build(((BlockTree)tree).body());
                break;
            }
            case RETURN_STATEMENT: {
                this.buildReturnStatement((ReturnStatementTree)tree);
                break;
            }
            case EXPRESSION_STATEMENT: {
                this.build(((ExpressionStatementTree)tree).expression());
                break;
            }
            case METHOD_INVOCATION: {
                this.buildMethodInvocation((MethodInvocationTree)tree);
                break;
            }
            case IF_STATEMENT: {
                this.buildIfStatement((IfStatementTree)tree);
                break;
            }
            case CONDITIONAL_EXPRESSION: {
                this.buildConditionalExpression((ConditionalExpressionTree)tree);
                break;
            }
            case VARIABLE: {
                this.buildVariable((VariableTree)tree);
                break;
            }
            case MULTIPLY: 
            case DIVIDE: 
            case REMAINDER: 
            case PLUS: 
            case MINUS: 
            case LEFT_SHIFT: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: 
            case AND: 
            case XOR: 
            case OR: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL_TO: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL_TO: 
            case EQUAL_TO: 
            case NOT_EQUAL_TO: {
                this.buildBinaryExpression(tree);
                break;
            }
            case ASSIGNMENT: 
            case LEFT_SHIFT_ASSIGNMENT: 
            case RIGHT_SHIFT_ASSIGNMENT: 
            case AND_ASSIGNMENT: 
            case REMAINDER_ASSIGNMENT: 
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: 
            case OR_ASSIGNMENT: 
            case XOR_ASSIGNMENT: 
            case DIVIDE_ASSIGNMENT: 
            case MULTIPLY_ASSIGNMENT: 
            case PLUS_ASSIGNMENT: 
            case MINUS_ASSIGNMENT: {
                this.buildAssignment((AssignmentExpressionTree)tree);
                break;
            }
            case MEMBER_SELECT: {
                this.buildMemberSelect((MemberSelectExpressionTree)tree);
                break;
            }
            case CONDITIONAL_AND: {
                this.buildConditionalAnd((BinaryExpressionTree)tree);
                break;
            }
            case CONDITIONAL_OR: {
                this.buildConditionalOr((BinaryExpressionTree)tree);
                break;
            }
            case LABELED_STATEMENT: {
                this.buildLabeledStatement((LabeledStatementTree)tree);
                break;
            }
            case SWITCH_STATEMENT: {
                this.buildSwitchStatement((SwitchStatementTree)tree);
                break;
            }
            case BREAK_STATEMENT: {
                this.buildBreakStatement((BreakStatementTree)tree);
                break;
            }
            case CONTINUE_STATEMENT: {
                this.buildContinueStatement((ContinueStatementTree)tree);
                break;
            }
            case WHILE_STATEMENT: {
                this.buildWhileStatement((WhileStatementTree)tree);
                break;
            }
            case DO_STATEMENT: {
                this.buildDoWhileStatement((DoWhileStatementTree)tree);
                break;
            }
            case FOR_EACH_STATEMENT: {
                this.buildForEachStatement((ForEachStatement)tree);
                break;
            }
            case FOR_STATEMENT: {
                this.buildForStatement((ForStatementTree)tree);
                break;
            }
            case TRY_STATEMENT: {
                this.buildTryStatement((TryStatementTree)tree);
                break;
            }
            case THROW_STATEMENT: {
                this.buildThrowStatement((ThrowStatementTree)tree);
                break;
            }
            case SYNCHRONIZED_STATEMENT: {
                this.buildSynchronizedStatement((SynchronizedStatementTree)tree);
                break;
            }
            case POSTFIX_INCREMENT: 
            case POSTFIX_DECREMENT: 
            case PREFIX_INCREMENT: 
            case PREFIX_DECREMENT: 
            case UNARY_MINUS: 
            case UNARY_PLUS: 
            case BITWISE_COMPLEMENT: 
            case LOGICAL_COMPLEMENT: {
                this.buildUnaryExpression((UnaryExpressionTree)tree);
                break;
            }
            case PARENTHESIZED_EXPRESSION: {
                this.build(((ParenthesizedTree)tree).expression());
                break;
            }
            case ARRAY_ACCESS_EXPRESSION: {
                this.buildArrayAccessExpression((ArrayAccessExpressionTree)tree);
                break;
            }
            case ARRAY_DIMENSION: {
                this.buildArrayDimension((ArrayDimensionTree)tree);
                break;
            }
            case NEW_CLASS: {
                this.buildNewClass((NewClassTree)tree);
                break;
            }
            case TYPE_CAST: {
                this.buildTypeCast(tree);
                break;
            }
            case INSTANCE_OF: {
                this.buildInstanceOf((InstanceOfTree)tree);
                break;
            }
            case NEW_ARRAY: {
                this.buildNewArray((NewArrayTree)tree);
                break;
            }
            case METHOD_REFERENCE: 
            case ASSERT_STATEMENT: {
                break;
            }
            case EMPTY_STATEMENT: 
            case CLASS: 
            case ENUM: 
            case ANNOTATION_TYPE: 
            case INTERFACE: 
            case LAMBDA_EXPRESSION: 
            case IDENTIFIER: 
            case INT_LITERAL: 
            case LONG_LITERAL: 
            case DOUBLE_LITERAL: 
            case CHAR_LITERAL: 
            case FLOAT_LITERAL: 
            case STRING_LITERAL: 
            case BOOLEAN_LITERAL: 
            case NULL_LITERAL: {
                this.currentBlock.elements.add(tree);
                break;
            }
            default: {
                throw new UnsupportedOperationException(tree.kind().name() + " " + ((JavaTree)tree).getLine());
            }
        }
    }

    private void buildReturnStatement(ReturnStatementTree tree) {
        ReturnStatementTree s = tree;
        this.currentBlock = this.createUnconditionalJump(s, this.exitBlock);
        ExpressionTree expression = s.expression();
        if (expression != null) {
            this.build(expression);
        }
    }

    private void buildMethodInvocation(MethodInvocationTree tree) {
        MethodInvocationTree mit = tree;
        this.currentBlock.elements.add(mit);
        this.build(mit.methodSelect());
        for (ExpressionTree arg : Lists.reverse((List)mit.arguments())) {
            this.build(arg);
        }
    }

    private void buildIfStatement(IfStatementTree tree) {
        Block next;
        IfStatementTree ifStatementTree = tree;
        Block elseBlock = next = this.currentBlock;
        StatementTree elseStatement = ifStatementTree.elseStatement();
        if (elseStatement != null) {
            if (!elseStatement.is(Tree.Kind.IF_STATEMENT)) {
                this.currentBlock = this.createBlock(next);
            }
            this.build(elseStatement);
            elseBlock = this.currentBlock;
        }
        this.currentBlock = this.createBlock(next);
        this.build(ifStatementTree.thenStatement());
        Block thenBlock = this.currentBlock;
        this.currentBlock = this.createBranch(ifStatementTree, thenBlock, elseBlock);
        this.buildCondition(ifStatementTree.condition(), thenBlock, elseBlock);
    }

    private void buildConditionalExpression(ConditionalExpressionTree tree) {
        ConditionalExpressionTree cond = tree;
        Block next = this.currentBlock;
        ExpressionTree elseStatement = cond.falseExpression();
        this.currentBlock = this.createBlock(next);
        this.build(elseStatement);
        Block elseBlock = this.currentBlock;
        this.currentBlock = this.createBlock(next);
        this.build(cond.trueExpression());
        Block thenBlock = this.currentBlock;
        this.currentBlock = this.createBranch(cond, thenBlock, elseBlock);
        this.buildCondition(cond.condition(), thenBlock, elseBlock);
    }

    private void buildVariable(VariableTree tree) {
        this.currentBlock.elements.add(tree);
        ExpressionTree initializer = tree.initializer();
        if (initializer != null) {
            this.build(initializer);
        }
    }

    private void buildBinaryExpression(Tree tree) {
        BinaryExpressionTree binaryExpressionTree = (BinaryExpressionTree)tree;
        this.currentBlock.elements.add(tree);
        this.build(binaryExpressionTree.rightOperand());
        this.build(binaryExpressionTree.leftOperand());
    }

    private void buildAssignment(AssignmentExpressionTree tree) {
        this.currentBlock.elements.add(tree);
        this.build(tree.variable());
        this.build(tree.expression());
    }

    private void buildMemberSelect(MemberSelectExpressionTree tree) {
        MemberSelectExpressionTree mse = tree;
        this.currentBlock.elements.add(mse);
        if (!"class".equals(mse.identifier().name())) {
            this.build(mse.expression());
        }
    }

    private void buildConditionalAnd(BinaryExpressionTree tree) {
        Block falseBlock = this.currentBlock;
        this.currentBlock = this.createBlock(falseBlock);
        this.build(tree.rightOperand());
        Block trueBlock = this.currentBlock;
        this.currentBlock = this.createBranch(tree, trueBlock, falseBlock);
        this.build(tree.leftOperand());
    }

    private void buildConditionalOr(BinaryExpressionTree tree) {
        Block trueBlock = this.currentBlock;
        this.currentBlock = this.createBlock(trueBlock);
        this.build(tree.rightOperand());
        Block falseBlock = this.currentBlock;
        this.currentBlock = this.createBranch(tree, trueBlock, falseBlock);
        this.build(tree.leftOperand());
    }

    private void buildLabeledStatement(LabeledStatementTree tree) {
        LabeledStatementTree s = tree;
        this.build(s.statement());
        this.currentBlock = this.createBlock(this.currentBlock);
        this.labels.put(s.label().name(), this.currentBlock);
    }

    private void buildSwitchStatement(SwitchStatementTree tree) {
        SwitchStatementTree switchStatementTree = tree;
        Block switchSuccessor = this.currentBlock;
        this.currentBlock = this.createBlock();
        this.currentBlock.terminator = switchStatementTree;
        this.switches.addLast(this.currentBlock);
        this.build(switchStatementTree.expression());
        this.currentBlock = this.createBlock(switchSuccessor);
        this.breakTargets.addLast(switchSuccessor);
        if (!switchStatementTree.cases().isEmpty()) {
            CaseGroupTree firstCase = switchStatementTree.cases().get(0);
            for (CaseGroupTree caseGroupTree : Lists.reverse(switchStatementTree.cases())) {
                this.build(caseGroupTree.body());
                this.switches.getLast().successors.add(this.currentBlock);
                if (caseGroupTree.equals(firstCase)) continue;
                this.currentBlock = this.createBlock(this.currentBlock);
            }
        }
        this.breakTargets.removeLast();
        this.currentBlock = this.switches.removeLast();
    }

    private void buildBreakStatement(BreakStatementTree tree) {
        if (tree.label() == null) {
            if (this.breakTargets.isEmpty()) {
                throw new IllegalStateException("'break' statement not in loop or switch statement");
            }
            this.currentBlock = this.createUnconditionalJump(tree, this.breakTargets.getLast());
        } else {
            this.currentBlock = this.createUnconditionalJump(tree, null);
            this.gotos.add(this.currentBlock);
        }
    }

    private void buildContinueStatement(ContinueStatementTree tree) {
        if (tree.label() == null) {
            if (this.continueTargets.isEmpty()) {
                throw new IllegalStateException("'continue' statement not in loop or switch statement");
            }
            this.currentBlock = this.createUnconditionalJump(tree, this.continueTargets.getLast());
        } else {
            this.currentBlock = this.createUnconditionalJump(tree, null);
            this.gotos.add(this.currentBlock);
        }
    }

    private void buildWhileStatement(WhileStatementTree tree) {
        WhileStatementTree s = tree;
        Block falseBranch = this.currentBlock;
        Block loopback = this.createBlock();
        this.currentBlock = this.createBlock(loopback);
        this.continueTargets.addLast(loopback);
        this.breakTargets.addLast(falseBranch);
        this.build(s.statement());
        this.breakTargets.removeLast();
        this.continueTargets.removeLast();
        Block bodyBlock = this.currentBlock;
        this.currentBlock = this.createBranch(s, bodyBlock, falseBranch);
        this.buildCondition(s.condition(), bodyBlock, falseBranch);
        loopback.successors.add(this.currentBlock);
        this.currentBlock = this.createBlock(this.currentBlock);
    }

    private void buildDoWhileStatement(DoWhileStatementTree tree) {
        DoWhileStatementTree s = tree;
        Block falseBranch = this.currentBlock;
        Block loopback = this.createBlock();
        this.currentBlock = this.createBranch(s, loopback, falseBranch);
        this.buildCondition(s.condition(), loopback, falseBranch);
        this.currentBlock = this.createBlock(this.currentBlock);
        this.continueTargets.addLast(loopback);
        this.breakTargets.addLast(falseBranch);
        this.build(s.statement());
        this.breakTargets.removeLast();
        this.continueTargets.removeLast();
        loopback.successors.add(this.currentBlock);
        this.currentBlock = this.createBlock(this.currentBlock);
    }

    private void buildForEachStatement(ForEachStatement tree) {
        Block afterLoop = this.currentBlock;
        Block loopback = this.currentBlock = this.createBlock();
        this.continueTargets.addLast(loopback);
        this.breakTargets.addLast(afterLoop);
        this.build(tree.statement());
        this.breakTargets.removeLast();
        this.continueTargets.removeLast();
        this.currentBlock = this.createBranch(tree, this.currentBlock, afterLoop);
        loopback.successors.add(this.currentBlock);
        this.build(tree.variable());
        this.build(tree.expression());
        this.currentBlock = this.createBlock(this.currentBlock);
    }

    private void buildForStatement(ForStatementTree tree) {
        Block falseBranch = this.currentBlock;
        Block updateBlock = this.currentBlock = this.createBlock();
        for (StatementTree updateTree : Lists.reverse(tree.update())) {
            this.build(updateTree);
        }
        this.continueTargets.addLast(this.currentBlock);
        this.currentBlock = this.createBlock(this.currentBlock);
        this.breakTargets.addLast(falseBranch);
        this.build(tree.statement());
        this.breakTargets.removeLast();
        this.continueTargets.removeLast();
        Block body = this.currentBlock;
        ExpressionTree condition = tree.condition();
        if (condition != null) {
            this.currentBlock = this.createBranch(tree, body, falseBranch);
            this.buildCondition(condition, body, falseBranch);
        } else {
            this.currentBlock = this.createUnconditionalJump(tree, body);
        }
        updateBlock.successors.add(this.currentBlock);
        this.currentBlock = this.createBlock(this.currentBlock);
        for (StatementTree init : Lists.reverse(tree.initializer())) {
            this.build(init);
        }
    }

    private void buildTryStatement(TryStatementTree tree) {
        TryStatementTree tryStatementTree = tree;
        this.currentBlock = this.createBlock(this.currentBlock);
        BlockTree finallyBlock = tryStatementTree.finallyBlock();
        if (finallyBlock != null) {
            this.build(finallyBlock);
        }
        this.currentBlock = this.createBlock(this.currentBlock);
        this.build(tryStatementTree.block());
        this.build((List<? extends Tree>)tryStatementTree.resources());
        this.currentBlock = this.createBlock(this.currentBlock);
        this.currentBlock.elements.add(tree);
    }

    private void buildThrowStatement(ThrowStatementTree tree) {
        ThrowStatementTree throwStatementTree = tree;
        this.currentBlock = this.createUnconditionalJump(throwStatementTree, this.exitBlock);
        this.build(throwStatementTree.expression());
    }

    private void buildSynchronizedStatement(SynchronizedStatementTree tree) {
        SynchronizedStatementTree sst = tree;
        this.build(sst.block());
        this.build(sst.expression());
    }

    private void buildUnaryExpression(UnaryExpressionTree tree) {
        this.currentBlock.elements.add(tree);
        this.build(tree.expression());
    }

    private void buildArrayAccessExpression(ArrayAccessExpressionTree tree) {
        this.currentBlock.elements.add(tree);
        this.build(tree.expression());
        this.build(tree.dimension());
    }

    private void buildArrayDimension(ArrayDimensionTree tree) {
        ExpressionTree expression = tree.expression();
        if (expression != null) {
            this.build(expression);
        }
    }

    private void buildNewClass(NewClassTree tree) {
        this.currentBlock.elements.add(tree);
        ExpressionTree enclosingExpression = tree.enclosingExpression();
        if (enclosingExpression != null) {
            this.build(enclosingExpression);
        }
        this.build(Lists.reverse((List)tree.arguments()));
    }

    private void buildTypeCast(Tree tree) {
        this.currentBlock.elements.add(tree);
        TypeCastTree typeCastTree = (TypeCastTree)tree;
        this.build(typeCastTree.expression());
    }

    private void buildInstanceOf(InstanceOfTree instanceOfTree) {
        this.currentBlock.elements.add(instanceOfTree);
        this.build(instanceOfTree.expression());
    }

    private void buildNewArray(NewArrayTree tree) {
        this.currentBlock.elements.add(tree);
        this.build(Lists.reverse(tree.dimensions()));
        this.build(Lists.reverse(tree.initializers()));
    }

    private Block createUnconditionalJump(Tree terminator, @Nullable Block target) {
        Block result = this.createBlock();
        result.terminator = terminator;
        if (target != null) {
            result.successors.add(target);
        }
        return result;
    }

    private void buildCondition(Tree syntaxNode, Block trueBlock, Block falseBlock) {
        switch (syntaxNode.kind()) {
            case CONDITIONAL_OR: {
                this.buildConditionalOr((BinaryExpressionTree)syntaxNode, trueBlock, falseBlock);
                break;
            }
            case CONDITIONAL_AND: {
                this.buildConditionalAnd((BinaryExpressionTree)syntaxNode, trueBlock, falseBlock);
                break;
            }
            case PARENTHESIZED_EXPRESSION: {
                this.buildCondition(((ParenthesizedTree)syntaxNode).expression(), trueBlock, falseBlock);
                break;
            }
            default: {
                this.build(syntaxNode);
            }
        }
    }

    private void buildConditionalOr(BinaryExpressionTree conditionalOr, Block trueBlock, Block falseBlock) {
        this.buildCondition(conditionalOr.rightOperand(), trueBlock, falseBlock);
        Block newFalseBlock = this.currentBlock;
        this.currentBlock = this.createBranch(conditionalOr, trueBlock, newFalseBlock);
        this.buildCondition(conditionalOr.leftOperand(), trueBlock, newFalseBlock);
    }

    private void buildConditionalAnd(BinaryExpressionTree conditionalAnd, Block trueBlock, Block falseBlock) {
        this.buildCondition(conditionalAnd.rightOperand(), trueBlock, falseBlock);
        Block newTrueBlock = this.currentBlock;
        this.currentBlock = this.createBranch(conditionalAnd, newTrueBlock, falseBlock);
        this.buildCondition(conditionalAnd.leftOperand(), newTrueBlock, falseBlock);
    }

    private Block createBranch(Tree terminator, Block trueBranch, Block falseBranch) {
        Block result = this.createBlock();
        result.terminator = terminator;
        result.successors.add(trueBranch);
        result.successors.add(falseBranch);
        return result;
    }

    public void debugTo(PrintStream out) {
        for (Block block : Lists.reverse(this.blocks)) {
            if (block.id != 0) {
                out.println("B" + block.id + ":");
            } else {
                out.println("B" + block.id + " (Exit) :");
            }
            int i = 0;
            for (Tree tree : block.elements()) {
                out.println("  " + i + ": " + CFG.syntaxNodeToDebugString(tree));
                ++i;
            }
            if (block.terminator != null) {
                out.println("  T: " + CFG.syntaxNodeToDebugString(block.terminator));
            }
            if (block.successors.isEmpty()) continue;
            out.print("  Successors:");
            for (Block successor : block.successors) {
                out.print(" B" + successor.id);
            }
            out.println();
        }
        out.println();
    }

    private static String syntaxNodeToDebugString(Tree syntaxNode) {
        StringBuilder sb = new StringBuilder(syntaxNode.kind().name()).append(' ').append(Integer.toHexString(syntaxNode.hashCode()));
        switch (syntaxNode.kind()) {
            case VARIABLE: {
                sb.append(' ').append(((VariableTree)syntaxNode).simpleName().name());
                break;
            }
            case IDENTIFIER: {
                sb.append(' ').append(((IdentifierTree)syntaxNode).identifierToken().text());
                break;
            }
            case INT_LITERAL: {
                sb.append(' ').append(((LiteralTree)syntaxNode).token().text());
                break;
            }
        }
        return sb.toString();
    }

    public static class Block {
        public final int id;
        private final List<Tree> elements = new ArrayList<Tree>();
        private final List<Block> successors = new ArrayList<Block>();
        private final List<Block> predecessors = new ArrayList<Block>();
        private Tree terminator;

        public Block(int id) {
            this.id = id;
        }

        public List<Tree> elements() {
            return Lists.reverse(this.elements);
        }

        public List<Block> predecessors() {
            return this.predecessors;
        }

        public List<Block> successors() {
            return this.successors;
        }

        @CheckForNull
        public Tree terminator() {
            return this.terminator;
        }
    }
}

