/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.java.AnalyzerMessage;
import org.sonar.java.SonarComponents;
import org.sonar.java.model.DefaultJavaFileScannerContext;
import org.sonar.java.model.InternalVisitorsBridge;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleLinearRemediation;
import org.sonar.squidbridge.annotations.SqaleLinearWithOffsetRemediation;
import org.sonar.squidbridge.api.CheckMessage;
import org.sonar.squidbridge.api.SourceFile;

public class VisitorsBridge
extends InternalVisitorsBridge {
    private TestJavaFileScannerContext testContext;

    @VisibleForTesting
    public VisitorsBridge(JavaFileScanner visitor) {
        this(Arrays.asList(visitor), Lists.newArrayList(), null);
    }

    @VisibleForTesting
    public VisitorsBridge(JavaFileScanner visitor, List<File> projectClasspath) {
        this(Arrays.asList(visitor), projectClasspath, null);
    }

    public VisitorsBridge(Iterable visitors, List<File> projectClasspath, @Nullable SonarComponents sonarComponents) {
        super(visitors, projectClasspath, sonarComponents);
    }

    @Override
    protected JavaFileScannerContext createScannerContext(CompilationUnitTree tree, SemanticModel semanticModel, boolean analyseAccessors, SonarComponents sonarComponents) {
        this.testContext = new TestJavaFileScannerContext(tree, (SourceFile)this.getContext().peekSourceCode(), this.getContext().getFile(), semanticModel, analyseAccessors, sonarComponents, this.getJavaVersion());
        return this.testContext;
    }

    public TestJavaFileScannerContext lastCreatedTestContext() {
        return this.testContext;
    }

    public static class TestJavaFileScannerContext
    extends DefaultJavaFileScannerContext {
        private final Set<AnalyzerMessage> issues = new HashSet<AnalyzerMessage>();

        public TestJavaFileScannerContext(CompilationUnitTree tree, SourceFile sourceFile, File file, SemanticModel semanticModel, boolean analyseAccessors, @Nullable SonarComponents sonarComponents, @Nullable Integer javaVersion) {
            super(tree, sourceFile, file, semanticModel, analyseAccessors, sonarComponents, javaVersion);
        }

        public Set<AnalyzerMessage> getIssues() {
            return this.issues;
        }

        @Override
        public void addIssue(int line, JavaCheck javaCheck, String message, @Nullable Double cost) {
            this.issues.add(new AnalyzerMessage(javaCheck, this.getFile(), line, message, cost != null ? cost.intValue() : 0));
            this.addIssueForCheckMessageVerifier(line, javaCheck, message, cost);
        }

        @Deprecated
        private void addIssueForCheckMessageVerifier(int line, JavaCheck javaCheck, String message, @Nullable Double cost) {
            CheckMessage checkMessage = new CheckMessage((Object)javaCheck, message, new Object[0]);
            if (line > 0) {
                checkMessage.setLine(line);
            }
            if (cost == null) {
                Annotation linear = AnnotationUtils.getAnnotation((Object)javaCheck, SqaleLinearRemediation.class);
                Annotation linearWithOffset = AnnotationUtils.getAnnotation((Object)javaCheck, SqaleLinearWithOffsetRemediation.class);
                if (linear != null || linearWithOffset != null) {
                    throw new IllegalStateException("A check annotated with a linear sqale function should provide an effort to fix");
                }
            } else {
                checkMessage.setCost(cost.doubleValue());
            }
            this.sourceFile.log(checkMessage);
        }

        @Override
        public void reportIssue(JavaCheck javaCheck, Tree syntaxNode, String message, List<JavaFileScannerContext.Location> secondary, @Nullable Integer cost) {
            File file = this.getFile();
            AnalyzerMessage analyzerMessage = new AnalyzerMessage(javaCheck, file, TestJavaFileScannerContext.textSpanFor(syntaxNode), message, cost != null ? cost : 0);
            for (JavaFileScannerContext.Location location : secondary) {
                AnalyzerMessage secondaryLocation = new AnalyzerMessage(javaCheck, file, TestJavaFileScannerContext.textSpanFor(location.syntaxNode), location.msg, 0);
                analyzerMessage.secondaryLocations.add(secondaryLocation);
            }
            this.issues.add(analyzerMessage);
            this.addIssueForCheckMessageVerifier(analyzerMessage.getLine(), javaCheck, message, Double.valueOf(cost != null ? cost : 0));
        }
    }
}

