/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.declaration;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.ast.parser.FormalParametersListTreeImpl;
import org.sonar.java.ast.parser.QualifiedIdentifierListTreeImpl;
import org.sonar.java.ast.parser.TypeParameterListTreeImpl;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.java.model.declaration.ModifiersTreeImpl;
import org.sonar.java.model.declaration.VariableTreeImpl;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeParameters;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class MethodTreeImpl
extends JavaTree
implements MethodTree {
    private ModifiersTree modifiers;
    private TypeParameters typeParameters = new TypeParameterListTreeImpl();
    @Nullable
    private TypeTree returnType;
    private IdentifierTree simpleName;
    private final SyntaxToken openParenToken;
    private final FormalParametersListTreeImpl parameters;
    private final SyntaxToken closeParenToken;
    @Nullable
    private final BlockTree block;
    @Nullable
    private SyntaxToken semicolonToken;
    @Nullable
    private final SyntaxToken throwsToken;
    private final ListTree<TypeTree> throwsClauses;
    private final SyntaxToken defaultToken;
    private final ExpressionTree defaultValue;
    @Nullable
    private JavaSymbol.MethodJavaSymbol symbol;

    public MethodTreeImpl(FormalParametersListTreeImpl parameters, @Nullable SyntaxToken defaultToken, @Nullable ExpressionTree defaultValue) {
        super(Tree.Kind.METHOD);
        this.parameters = parameters;
        this.openParenToken = parameters.openParenToken();
        this.closeParenToken = parameters.closeParenToken();
        this.block = null;
        this.throwsToken = null;
        this.throwsClauses = QualifiedIdentifierListTreeImpl.emptyList();
        this.defaultToken = defaultToken;
        this.defaultValue = defaultValue;
    }

    public MethodTreeImpl(@Nullable TypeTree returnType, IdentifierTree simpleName, FormalParametersListTreeImpl parameters, @Nullable SyntaxToken throwsToken, ListTree<TypeTree> throwsClauses, @Nullable BlockTree block, @Nullable SyntaxToken semicolonToken) {
        super(returnType == null ? Tree.Kind.CONSTRUCTOR : Tree.Kind.METHOD);
        this.modifiers = null;
        this.returnType = returnType;
        this.simpleName = (IdentifierTree)Preconditions.checkNotNull((Object)simpleName);
        this.parameters = (FormalParametersListTreeImpl)Preconditions.checkNotNull((Object)parameters);
        this.openParenToken = parameters.openParenToken();
        this.closeParenToken = parameters.closeParenToken();
        this.block = block;
        this.semicolonToken = semicolonToken;
        this.throwsToken = throwsToken;
        this.throwsClauses = (ListTree)Preconditions.checkNotNull(throwsClauses);
        this.defaultToken = null;
        this.defaultValue = null;
    }

    public MethodTreeImpl complete(TypeTree returnType, IdentifierTree simpleName, SyntaxToken semicolonToken) {
        Preconditions.checkState((this.simpleName == null ? 1 : 0) != 0);
        this.returnType = returnType;
        this.simpleName = simpleName;
        this.semicolonToken = semicolonToken;
        return this;
    }

    public MethodTreeImpl completeWithTypeParameters(TypeParameterListTreeImpl typeParameters) {
        this.typeParameters = typeParameters;
        return this;
    }

    public MethodTreeImpl completeWithModifiers(ModifiersTreeImpl modifiers) {
        Preconditions.checkState((this.modifiers == null ? 1 : 0) != 0);
        this.modifiers = modifiers;
        return this;
    }

    @Override
    public Tree.Kind kind() {
        return this.returnType == null ? Tree.Kind.CONSTRUCTOR : Tree.Kind.METHOD;
    }

    @Override
    public ModifiersTree modifiers() {
        return this.modifiers;
    }

    @Override
    public TypeParameters typeParameters() {
        return this.typeParameters;
    }

    @Override
    @Nullable
    public TypeTree returnType() {
        return this.returnType;
    }

    @Override
    public IdentifierTree simpleName() {
        return this.simpleName;
    }

    @Override
    public SyntaxToken openParenToken() {
        return this.openParenToken;
    }

    @Override
    public List<VariableTree> parameters() {
        return this.parameters;
    }

    @Override
    public SyntaxToken closeParenToken() {
        return this.closeParenToken;
    }

    @Override
    public ListTree<TypeTree> throwsClauses() {
        return this.throwsClauses;
    }

    @Override
    @Nullable
    public BlockTree block() {
        return this.block;
    }

    @Override
    @Nullable
    public SyntaxToken semicolonToken() {
        return this.semicolonToken;
    }

    @Override
    @Nullable
    public SyntaxToken defaultToken() {
        return this.defaultToken;
    }

    @Override
    @Nullable
    public ExpressionTree defaultValue() {
        return this.defaultValue;
    }

    @Override
    public Symbol.MethodSymbol symbol() {
        return this.symbol;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitMethod(this);
    }

    public void setSymbol(JavaSymbol.MethodJavaSymbol symbol) {
        Preconditions.checkState((this.symbol == null ? 1 : 0) != 0);
        this.symbol = symbol;
    }

    @Override
    public int getLine() {
        return this.parameters.openParenToken().getLine();
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        ImmutableList.Builder iteratorBuilder = ImmutableList.builder();
        iteratorBuilder.add((Object[])new Tree[]{this.modifiers, this.typeParameters});
        if (this.returnType != null) {
            iteratorBuilder.add((Object)this.returnType);
        }
        iteratorBuilder.add((Object[])new Tree[]{this.simpleName, this.openParenToken});
        iteratorBuilder.addAll(this.parameters.iterator());
        iteratorBuilder.add((Object)this.closeParenToken);
        if (this.throwsToken != null) {
            iteratorBuilder.add((Object)this.throwsToken);
            iteratorBuilder.add(this.throwsClauses);
        }
        if (this.defaultToken != null) {
            iteratorBuilder.add((Object[])new Tree[]{this.defaultToken, this.defaultValue});
        }
        if (this.block != null) {
            iteratorBuilder.add((Object)this.block);
        } else {
            iteratorBuilder.add((Object)this.semicolonToken);
        }
        return iteratorBuilder.build().iterator();
    }

    @CheckForNull
    public Boolean isOverriding() {
        if (this.isStatic() || this.isPrivate()) {
            return false;
        }
        if (this.isAnnotatedOverride()) {
            return true;
        }
        if (this.symbol == null) {
            return null;
        }
        return this.symbol.isOverriden();
    }

    private boolean isStatic() {
        return ModifiersUtils.hasModifier(this.modifiers, Modifier.STATIC);
    }

    private boolean isPrivate() {
        return ModifiersUtils.hasModifier(this.modifiers, Modifier.PRIVATE);
    }

    private boolean isPublic() {
        return ModifiersUtils.hasModifier(this.modifiers, Modifier.PUBLIC);
    }

    public boolean isAnnotatedOverride() {
        for (AnnotationTree annotationTree : this.modifiers.annotations()) {
            if (!annotationTree.annotationType().is(Tree.Kind.IDENTIFIER)) continue;
            IdentifierTree identifier = (IdentifierTree)annotationTree.annotationType();
            if (!Override.class.getSimpleName().equals(identifier.name())) continue;
            return true;
        }
        return false;
    }

    public boolean isMainMethod() {
        return this.isPublicStatic() && this.isNamed("main") && this.returnsVoid() && this.hasStringArrayParameter();
    }

    private boolean isPublicStatic() {
        return this.isStatic() && this.isPublic();
    }

    private boolean hasStringArrayParameter() {
        return this.parameters.size() == 1 && this.isParameterStringArray();
    }

    private boolean isParameterStringArray() {
        VariableTree variableTree = (VariableTree)this.parameters.get(0);
        boolean result = false;
        if (variableTree.type().is(Tree.Kind.ARRAY_TYPE)) {
            ArrayTypeTree arrayTypeTree = (ArrayTypeTree)variableTree.type();
            result = arrayTypeTree.type().symbolType().isClass() && "String".equals(arrayTypeTree.type().symbolType().name());
        }
        return result;
    }

    private boolean returnsVoid() {
        return this.returnsPrimitive("void");
    }

    private boolean isNamed(String name) {
        return name.equals(this.simpleName().name());
    }

    public boolean isEqualsMethod() {
        boolean hasEqualsSignature = this.isNamed("equals") && this.returnsBoolean() && this.hasObjectParameter();
        return this.isPublic() && !this.isStatic() && hasEqualsSignature;
    }

    private boolean hasObjectParameter() {
        return this.parameters.size() == 1 && ((VariableTreeImpl)this.parameters.get(0)).type().symbolType().is("java.lang.Object");
    }

    private boolean returnsBoolean() {
        return this.returnsPrimitive("boolean");
    }

    private boolean returnsPrimitive(String primitive) {
        if (this.returnType != null) {
            return this.returnType.is(Tree.Kind.PRIMITIVE_TYPE) && primitive.equals(((PrimitiveTypeTree)this.returnType).keyword().text());
        }
        return false;
    }

    public boolean isHashCodeMethod() {
        boolean hasHashCodeSignature = this.isNamed("hashCode") && this.parameters.isEmpty() && this.returnsInt();
        return this.isPublic() && !this.isStatic() && hasHashCodeSignature;
    }

    private boolean returnsInt() {
        return this.returnsPrimitive("int");
    }

    public boolean isToStringMethod() {
        boolean hasToStringSignature = this.isNamed("toString") && this.parameters.isEmpty() && this.returnsString();
        return this.isPublic() && !this.isStatic() && hasToStringSignature;
    }

    private boolean returnsString() {
        if (this.returnType != null) {
            return this.returnType.symbolType().is("java.lang.String");
        }
        return false;
    }
}

