/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.declaration;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.declaration.ModifiersTreeImpl;
import org.sonar.java.model.expression.IdentifierTreeImpl;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.InferedTypeTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class VariableTreeImpl
extends JavaTree
implements VariableTree {
    private ModifiersTree modifiers;
    private TypeTree type;
    private IdentifierTree simpleName;
    @Nullable
    private SyntaxToken equalToken;
    @Nullable
    private ExpressionTree initializer;
    @Nullable
    private SyntaxToken endToken;
    private JavaSymbol.VariableJavaSymbol symbol;
    @Nullable
    private JavaTree.ArrayTypeTreeImpl nestedDimensions;
    private boolean vararg = false;

    public VariableTreeImpl(IdentifierTreeImpl simpleName, @Nullable JavaTree.ArrayTypeTreeImpl nestedDimensions) {
        super(Tree.Kind.VARIABLE);
        this.modifiers = ModifiersTreeImpl.emptyModifiers();
        this.simpleName = simpleName;
        this.nestedDimensions = nestedDimensions;
        this.initializer = null;
    }

    public VariableTreeImpl(InternalSyntaxToken equalToken, ExpressionTree initializer) {
        super(Tree.Kind.VARIABLE);
        this.equalToken = equalToken;
        this.initializer = initializer;
    }

    public VariableTreeImpl(IdentifierTreeImpl simpleName) {
        this(simpleName, null);
        this.type = new InferedTypeTree();
    }

    public VariableTreeImpl(Tree.Kind kind, ModifiersTree modifiers, IdentifierTree simpleName, @Nullable ExpressionTree initializer) {
        super(kind);
        this.modifiers = (ModifiersTree)Preconditions.checkNotNull((Object)modifiers);
        this.simpleName = (IdentifierTree)Preconditions.checkNotNull((Object)simpleName);
        this.initializer = initializer;
    }

    public VariableTreeImpl completeType(TypeTree type) {
        TypeTree actualType = type;
        if (this.nestedDimensions != null) {
            this.nestedDimensions.setLastChildType(type);
            actualType = this.nestedDimensions;
        }
        this.type = actualType;
        return this;
    }

    public VariableTreeImpl completeModifiers(ModifiersTreeImpl modifiers) {
        this.modifiers = modifiers;
        return this;
    }

    public VariableTreeImpl completeModifiersAndType(ModifiersTreeImpl modifiers, TypeTree type) {
        return this.completeModifiers(modifiers).completeType(type);
    }

    public VariableTreeImpl completeTypeAndInitializer(TypeTree type, InternalSyntaxToken equalToken, ExpressionTree initializer) {
        this.initializer = initializer;
        this.equalToken = equalToken;
        return this.completeType(type);
    }

    public VariableTreeImpl completeIdentifierAndDims(IdentifierTreeImpl simpleName, JavaTree.ArrayTypeTreeImpl nestedDimensions) {
        this.simpleName = simpleName;
        if (this.nestedDimensions != null) {
            JavaTree.ArrayTypeTreeImpl newType = nestedDimensions;
            newType.completeType(this.nestedDimensions);
            this.nestedDimensions = newType;
        } else {
            this.nestedDimensions = nestedDimensions;
        }
        return this;
    }

    public void addEllipsisDimension(JavaTree.ArrayTypeTreeImpl dimension) {
        this.vararg = true;
        if (this.nestedDimensions != null) {
            this.nestedDimensions.setLastChildType(dimension);
        } else {
            this.nestedDimensions = dimension;
        }
    }

    public boolean isVararg() {
        return this.vararg;
    }

    @Override
    public Tree.Kind kind() {
        return Tree.Kind.VARIABLE;
    }

    @Override
    public ModifiersTree modifiers() {
        return this.modifiers;
    }

    @Override
    public TypeTree type() {
        return this.type;
    }

    @Override
    public IdentifierTree simpleName() {
        return this.simpleName;
    }

    @Override
    @Nullable
    public ExpressionTree initializer() {
        return this.initializer;
    }

    @Override
    public Symbol symbol() {
        return this.symbol;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitVariable(this);
    }

    public JavaSymbol.VariableJavaSymbol getSymbol() {
        return this.symbol;
    }

    public void setSymbol(JavaSymbol.VariableJavaSymbol symbol) {
        Preconditions.checkState((this.symbol == null ? 1 : 0) != 0);
        this.symbol = symbol;
    }

    @Override
    public int getLine() {
        return ((IdentifierTreeImpl)this.simpleName()).getLine();
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        UnmodifiableIterator initializerIterator = this.initializer != null ? Iterators.forArray((Object[])new Tree[]{this.equalToken, this.initializer}) : Iterators.emptyIterator();
        UnmodifiableIterator endTokenIterator = this.endToken != null ? Iterators.singletonIterator((Object)this.endToken) : Iterators.emptyIterator();
        return Iterators.concat((Iterator)Iterators.forArray((Object[])new Tree[]{this.modifiers, this.type, this.simpleName}), (Iterator)initializerIterator, (Iterator)endTokenIterator);
    }

    @Override
    @CheckForNull
    public SyntaxToken endToken() {
        return this.endToken;
    }

    public void setEndToken(InternalSyntaxToken endToken) {
        this.endToken = endToken;
    }
}

