/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.expression.IdentifierTreeImpl;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeTree;

public class MemberSelectExpressionTreeImpl
extends AbstractTypedTree
implements MemberSelectExpressionTree {
    private ExpressionTree expression;
    @Nullable
    private final JavaTree.ArrayTypeTreeImpl nestedDimensions;
    private InternalSyntaxToken dotToken;
    private final IdentifierTree identifier;
    private List<AnnotationTree> annotations;

    public MemberSelectExpressionTreeImpl(@Nullable JavaTree.ArrayTypeTreeImpl nestedDimensions, InternalSyntaxToken dotToken, IdentifierTreeImpl identifier) {
        super(Tree.Kind.MEMBER_SELECT);
        this.nestedDimensions = nestedDimensions;
        this.dotToken = dotToken;
        this.identifier = identifier;
        this.annotations = ImmutableList.of();
    }

    public MemberSelectExpressionTreeImpl(ExpressionTree expression, InternalSyntaxToken dotToken, IdentifierTree identifier) {
        super(Tree.Kind.MEMBER_SELECT);
        this.nestedDimensions = null;
        this.expression = (ExpressionTree)Preconditions.checkNotNull((Object)expression);
        this.dotToken = dotToken;
        this.identifier = (IdentifierTree)Preconditions.checkNotNull((Object)identifier);
        this.annotations = ImmutableList.of();
    }

    public MemberSelectExpressionTreeImpl completeWithExpression(ExpressionTree expression) {
        Preconditions.checkState((this.expression == null ? 1 : 0) != 0);
        ExpressionTree result = expression;
        if (this.nestedDimensions != null) {
            this.nestedDimensions.setLastChildType((TypeTree)((Object)expression));
            result = this.nestedDimensions;
        }
        this.expression = result;
        return this;
    }

    public MemberSelectExpressionTreeImpl complete(List<AnnotationTree> annotations) {
        this.annotations = annotations;
        return this;
    }

    @Override
    public Tree.Kind kind() {
        return Tree.Kind.MEMBER_SELECT;
    }

    @Override
    public List<AnnotationTree> annotations() {
        return this.annotations;
    }

    @Override
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public SyntaxToken operatorToken() {
        return this.dotToken;
    }

    @Override
    public IdentifierTree identifier() {
        return this.identifier;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitMemberSelectExpression(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat(this.annotations.iterator(), (Iterator)Iterators.forArray((Object[])new Tree[]{this.expression, this.dotToken, this.identifier}));
    }
}

