/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.syntaxtoken;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.model.expression.TypeArgumentListTreeImpl;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.AssertStatementTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.BreakStatementTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.ContinueStatementTree;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.EmptyStatementTree;
import org.sonar.plugins.java.api.tree.EnumConstantTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.LabeledStatementTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ModifierKeywordTree;
import org.sonar.plugins.java.api.tree.ModifierTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.PackageDeclarationTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StaticInitializerTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.SynchronizedStatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.TypeParameterTree;
import org.sonar.plugins.java.api.tree.TypeParameters;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.UnionTypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;
import org.sonar.plugins.java.api.tree.WildcardTree;

public class FirstSyntaxTokenFinder
extends BaseTreeVisitor {
    private SyntaxToken firstSyntaxToken;

    private FirstSyntaxTokenFinder() {
    }

    @Nullable
    public static SyntaxToken firstSyntaxToken(Tree tree) {
        if (tree.is(Tree.Kind.TOKEN)) {
            return (SyntaxToken)tree;
        }
        FirstSyntaxTokenFinder visitor = new FirstSyntaxTokenFinder();
        tree.accept(visitor);
        return visitor.firstSyntaxToken;
    }

    @Override
    public void visitBlock(BlockTree tree) {
        this.firstSyntaxToken = tree.is(Tree.Kind.STATIC_INITIALIZER) ? ((StaticInitializerTree)tree).staticKeyword() : tree.openBraceToken();
    }

    @Override
    public void visitEmptyStatement(EmptyStatementTree tree) {
        this.firstSyntaxToken = tree.semicolonToken();
    }

    @Override
    public void visitExpressionStatement(ExpressionStatementTree tree) {
        this.scan(tree.expression());
    }

    @Override
    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        this.scan(tree.variable());
    }

    @Override
    public void visitArrayAccessExpression(ArrayAccessExpressionTree tree) {
        this.scan(tree.expression());
    }

    @Override
    public void visitMethodInvocation(MethodInvocationTree tree) {
        this.scan(tree.methodSelect());
    }

    @Override
    public void visitIfStatement(IfStatementTree tree) {
        this.firstSyntaxToken = tree.ifKeyword();
    }

    @Override
    public void visitAssertStatement(AssertStatementTree tree) {
        this.firstSyntaxToken = tree.assertKeyword();
    }

    @Override
    public void visitSwitchStatement(SwitchStatementTree tree) {
        this.firstSyntaxToken = tree.switchKeyword();
    }

    @Override
    public void visitCaseLabel(CaseLabelTree tree) {
        this.firstSyntaxToken = tree.caseOrDefaultKeyword();
    }

    @Override
    public void visitWhileStatement(WhileStatementTree tree) {
        this.firstSyntaxToken = tree.whileKeyword();
    }

    @Override
    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        this.firstSyntaxToken = tree.doKeyword();
    }

    @Override
    public void visitForStatement(ForStatementTree tree) {
        this.firstSyntaxToken = tree.forKeyword();
    }

    @Override
    public void visitForEachStatement(ForEachStatement tree) {
        this.firstSyntaxToken = tree.forKeyword();
    }

    @Override
    public void visitBreakStatement(BreakStatementTree tree) {
        this.firstSyntaxToken = tree.breakKeyword();
    }

    @Override
    public void visitContinueStatement(ContinueStatementTree tree) {
        this.firstSyntaxToken = tree.continueKeyword();
    }

    @Override
    public void visitReturnStatement(ReturnStatementTree tree) {
        this.firstSyntaxToken = tree.returnKeyword();
    }

    @Override
    public void visitThrowStatement(ThrowStatementTree tree) {
        this.firstSyntaxToken = tree.throwKeyword();
    }

    @Override
    public void visitSynchronizedStatement(SynchronizedStatementTree tree) {
        this.firstSyntaxToken = tree.synchronizedKeyword();
    }

    @Override
    public void visitTryStatement(TryStatementTree tree) {
        this.firstSyntaxToken = tree.tryKeyword();
    }

    @Override
    public void visitCatch(CatchTree tree) {
        this.firstSyntaxToken = tree.catchKeyword();
    }

    @Override
    public void visitMethod(MethodTree tree) {
        SyntaxToken firstModifierToken = FirstSyntaxTokenFinder.getFirstModifierToken(tree.modifiers());
        if (firstModifierToken != null) {
            this.firstSyntaxToken = firstModifierToken;
        } else {
            TypeParameters typeParameters = tree.typeParameters();
            if (!typeParameters.isEmpty()) {
                this.firstSyntaxToken = typeParameters.openBracketToken();
            } else if (tree.returnType() != null) {
                this.scan(tree.returnType());
            } else {
                this.firstSyntaxToken = tree.simpleName().identifierToken();
            }
        }
    }

    @CheckForNull
    private static SyntaxToken getFirstModifierToken(ModifiersTree modifiers) {
        if (!modifiers.isEmpty()) {
            ModifierTree firstModifier = (ModifierTree)modifiers.get(0);
            if (firstModifier.is(Tree.Kind.ANNOTATION)) {
                return ((AnnotationTree)firstModifier).atToken();
            }
            return ((ModifierKeywordTree)firstModifier).keyword();
        }
        return null;
    }

    @Override
    public void visitClass(ClassTree tree) {
        SyntaxToken firstModifierToken = FirstSyntaxTokenFinder.getFirstModifierToken(tree.modifiers());
        this.firstSyntaxToken = firstModifierToken != null ? firstModifierToken : (tree.declarationKeyword() != null ? tree.declarationKeyword() : tree.openBraceToken());
    }

    @Override
    public void visitVariable(VariableTree tree) {
        SyntaxToken firstModifierToken = FirstSyntaxTokenFinder.getFirstModifierToken(tree.modifiers());
        if (firstModifierToken != null) {
            this.firstSyntaxToken = firstModifierToken;
        } else if (!tree.type().is(Tree.Kind.INFERED_TYPE)) {
            this.scan(tree.type());
        } else {
            this.scan(tree.simpleName());
        }
    }

    @Override
    public void visitParameterizedType(ParameterizedTypeTree tree) {
        if (!tree.annotations().isEmpty()) {
            this.scan(tree.annotations());
        } else {
            this.scan(tree.type());
        }
    }

    @Override
    public void visitUnaryExpression(UnaryExpressionTree tree) {
        if (tree.is(Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.POSTFIX_DECREMENT)) {
            this.scan(tree.expression());
        } else {
            this.firstSyntaxToken = tree.operatorToken();
        }
    }

    @Override
    public void visitLabeledStatement(LabeledStatementTree tree) {
        this.firstSyntaxToken = tree.label().identifierToken();
    }

    @Override
    public void visitEnumConstant(EnumConstantTree tree) {
        this.firstSyntaxToken = tree.simpleName().identifierToken();
    }

    @Override
    public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
        if (!tree.annotations().isEmpty()) {
            this.scan(tree.annotations());
        } else {
            this.scan(tree.expression());
        }
    }

    @Override
    public void visitIdentifier(IdentifierTree tree) {
        if (!tree.annotations().isEmpty()) {
            this.scan(tree.annotations());
        } else {
            this.firstSyntaxToken = tree.identifierToken();
        }
    }

    @Override
    public void visitLiteral(LiteralTree tree) {
        this.firstSyntaxToken = tree.token();
    }

    @Override
    public void visitPrimitiveType(PrimitiveTypeTree tree) {
        if (!tree.annotations().isEmpty()) {
            this.scan(tree.annotations());
        } else {
            this.firstSyntaxToken = tree.keyword();
        }
    }

    @Override
    public void visitNewClass(NewClassTree tree) {
        if (tree.enclosingExpression() != null) {
            this.scan(tree.enclosingExpression());
        } else {
            this.firstSyntaxToken = tree.newKeyword();
        }
    }

    @Override
    public void visitParenthesized(ParenthesizedTree tree) {
        this.firstSyntaxToken = tree.openParenToken();
    }

    @Override
    public void visitBinaryExpression(BinaryExpressionTree tree) {
        this.scan(tree.leftOperand());
    }

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        if (tree.packageDeclaration() != null) {
            this.scan(tree.packageDeclaration());
        } else if (!tree.imports().isEmpty()) {
            this.scan(tree.imports().get(0));
        } else if (!tree.types().isEmpty()) {
            this.scan(tree.types().get(0));
        } else {
            this.firstSyntaxToken = tree.eofToken();
        }
    }

    @Override
    public void visitImport(ImportTree tree) {
        this.firstSyntaxToken = tree.importKeyword();
    }

    @Override
    public void visitCaseGroup(CaseGroupTree tree) {
        this.scan(tree.labels().get(0));
    }

    @Override
    public void visitConditionalExpression(ConditionalExpressionTree tree) {
        this.scan(tree.condition());
    }

    @Override
    public void visitNewArray(NewArrayTree tree) {
        this.firstSyntaxToken = tree.newKeyword();
    }

    @Override
    public void visitTypeCast(TypeCastTree tree) {
        this.firstSyntaxToken = tree.openParenToken();
    }

    @Override
    public void visitInstanceOf(InstanceOfTree tree) {
        this.scan(tree.expression());
    }

    @Override
    public void visitArrayType(ArrayTypeTree tree) {
        this.scan(tree.type());
    }

    @Override
    public void visitWildcard(WildcardTree tree) {
        if (!tree.annotations().isEmpty()) {
            this.scan(tree.annotations());
        } else {
            this.firstSyntaxToken = tree.queryToken();
        }
    }

    @Override
    public void visitUnionType(UnionTypeTree tree) {
        this.scan((Tree)tree.typeAlternatives().get(0));
    }

    @Override
    public void visitModifier(ModifiersTree modifiersTree) {
        this.firstSyntaxToken = FirstSyntaxTokenFinder.getFirstModifierToken(modifiersTree);
    }

    @Override
    public void visitAnnotation(AnnotationTree annotationTree) {
        this.firstSyntaxToken = annotationTree.atToken();
    }

    @Override
    public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        if (lambdaExpressionTree.openParenToken() != null) {
            this.firstSyntaxToken = lambdaExpressionTree.openParenToken();
        } else {
            this.scan(lambdaExpressionTree.parameters().get(0));
        }
    }

    @Override
    public void visitTypeParameter(TypeParameterTree typeParameter) {
        this.scan(typeParameter.identifier());
    }

    @Override
    public void visitTypeArguments(TypeArgumentListTreeImpl trees) {
        this.firstSyntaxToken = trees.openBracketToken();
    }

    @Override
    public void visitTypeParameters(TypeParameters trees) {
        this.firstSyntaxToken = trees.openBracketToken();
    }

    @Override
    public void visitMethodReference(MethodReferenceTree methodReferenceTree) {
        this.scan(methodReferenceTree.expression());
    }

    @Override
    public void visitOther(Tree tree) {
    }

    @Override
    public void visitPackage(PackageDeclarationTree tree) {
        if (!tree.annotations().isEmpty()) {
            this.scan(tree.annotations().get(0));
        } else {
            this.firstSyntaxToken = tree.packageKeyword();
        }
    }
}

