/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.checks.NoSonarFilter;
import org.sonar.api.config.Settings;
import org.sonar.api.design.Dependency;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Directory;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.rule.RuleKey;
import org.sonar.graph.DirectedGraph;
import org.sonar.java.JavaSquid;
import org.sonar.java.SonarComponents;
import org.sonar.java.bytecode.visitor.ResourceMapping;
import org.sonar.plugins.java.bridges.ChecksBridge;
import org.sonar.plugins.java.bridges.DesignBridge;
import org.sonar.squidbridge.api.SourceFile;

public class Bridges {
    private static final Logger LOG = LoggerFactory.getLogger(Bridges.class);
    private final JavaSquid squid;
    private final Settings settings;

    public Bridges(JavaSquid squid, Settings settings) {
        this.squid = squid;
        this.settings = settings;
    }

    public void save(SensorContext context, Project project, SonarComponents sonarComponents, ResourceMapping resourceMapping, NoSonarFilter noSonarFilter, RulesProfile rulesProfile) {
        boolean skipPackageDesignAnalysis = this.settings.getBoolean("sonar.skipPackageDesign");
        if (!skipPackageDesignAnalysis && this.squid.isBytecodeScanned()) {
            DesignBridge designBridge = new DesignBridge(context, (DirectedGraph<Resource, Dependency>)this.squid.getGraph(), resourceMapping, sonarComponents.getResourcePerspectives());
            designBridge.saveDesign(project);
        }
        ChecksBridge checksBridge = new ChecksBridge(sonarComponents, rulesProfile);
        this.reportIssues(resourceMapping, noSonarFilter, checksBridge, project);
    }

    private void reportIssues(ResourceMapping resourceMapping, NoSonarFilter noSonarFilter, ChecksBridge checksBridge, Project project) {
        ProjectIssue projectIssue = null;
        if (StringUtils.isNotBlank((String)this.settings.getString("sonar.java.jsonoutput.folder"))) {
            projectIssue = new ProjectIssue();
        }
        for (Resource directory : resourceMapping.directories()) {
            checksBridge.reportIssueForPackageInfo((Directory)directory, project, projectIssue);
            for (Resource sonarFile : resourceMapping.files((Directory)directory)) {
                String key = resourceMapping.getFileKeyByResource((org.sonar.api.resources.File)sonarFile);
                if (key == null) continue;
                SourceFile squidFile = (SourceFile)this.squid.search(key);
                if (squidFile != null) {
                    noSonarFilter.addResource(sonarFile, squidFile.getNoSonarTagLines());
                    checksBridge.reportIssues(squidFile, sonarFile, projectIssue);
                    continue;
                }
                LOG.error("Could not report issue on file: " + sonarFile.getKey());
            }
        }
        this.outputJson(projectIssue);
    }

    private void outputJson(@Nullable ProjectIssue projectIssue) {
        if (projectIssue != null) {
            File folder = new File(this.settings.getString("sonar.java.jsonoutput.folder"));
            folder.mkdir();
            LOG.info("Outputing json files to folder: " + folder.getAbsolutePath());
            for (Map.Entry<RuleKey, RuleIssues> entry : projectIssue.rules.entrySet()) {
                try {
                    PrintWriter pw = new PrintWriter(folder.getAbsolutePath() + File.separator + "squid-" + entry.getKey().rule() + ".json", Charsets.UTF_8.name());
                    Throwable throwable = null;
                    try {
                        Bridges.writeIssueFile(pw, entry.getValue());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (pw == null) continue;
                        if (throwable != null) {
                            try {
                                pw.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        pw.close();
                    }
                }
                catch (IOException e) {
                    LOG.error("Could not output json file for rule : " + entry.getKey(), (Throwable)e);
                }
            }
        }
    }

    private static void writeIssueFile(Writer pw, RuleIssues ruleIssues) throws IOException {
        pw.write("{\n");
        for (Map.Entry<String, FileIssues> stringFileIssuesEntry : ruleIssues.files.entrySet()) {
            FileIssues fileIssues = stringFileIssuesEntry.getValue();
            if (fileIssues.getLines().isEmpty()) continue;
            pw.write("'project:" + stringFileIssuesEntry.getKey() + "':[\n");
            for (Integer line : fileIssues.getLines()) {
                pw.write(line + ",\n");
            }
            pw.write("],\n");
        }
        pw.write("}\n");
    }

    private static class FileIssues {
        List<Integer> lines = new ArrayList<Integer>();

        private FileIssues() {
        }

        public List<Integer> getLines() {
            Collections.sort(this.lines);
            return this.lines;
        }
    }

    private static class RuleIssues {
        Map<String, FileIssues> files = new TreeMap<String, FileIssues>();

        private RuleIssues() {
        }

        public void addIssue(String name, @Nullable Integer line) {
            FileIssues fileIssues = this.files.get(name);
            if (fileIssues == null) {
                fileIssues = new FileIssues();
                this.files.put(name, fileIssues);
            }
            fileIssues.lines.add(line == null ? 0 : line);
        }
    }

    public static class ProjectIssue {
        Map<RuleKey, RuleIssues> rules = new HashMap<RuleKey, RuleIssues>();

        public void addIssue(RuleKey ruleKey, String name, @Nullable Integer line) {
            RuleIssues ruleIssues = this.rules.get(ruleKey);
            if (ruleIssues == null) {
                ruleIssues = new RuleIssues();
                this.rules.put(ruleKey, ruleIssues);
            }
            ruleIssues.addIssue(name, line);
        }
    }
}

