/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java;

import com.google.common.collect.Lists;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.Phase;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.config.Settings;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.DefaultJavaResourceLocator;
import org.sonar.java.JavaClasspath;
import org.sonar.java.JavaConfiguration;
import org.sonar.java.JavaSquid;
import org.sonar.java.Measurer;
import org.sonar.java.SonarComponents;
import org.sonar.java.checks.CheckList;
import org.sonar.java.filters.CodeVisitorIssueFilter;
import org.sonar.java.filters.PostAnalysisIssueFilter;
import org.sonar.java.model.JavaVersionImpl;
import org.sonar.plugins.java.api.JavaResourceLocator;
import org.sonar.plugins.java.api.JavaVersion;

@Phase(name=Phase.Name.PRE)
@DependsUpon(value={"BEFORE_SQUID"})
@DependedUpon(value={"squid"})
public class JavaSquidSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(JavaSquidSensor.class);
    private final JavaClasspath javaClasspath;
    private final SonarComponents sonarComponents;
    private final FileSystem fs;
    private final DefaultJavaResourceLocator javaResourceLocator;
    private final Settings settings;
    private final NoSonarFilter noSonarFilter;
    private final PostAnalysisIssueFilter postAnalysisIssueFilter;

    public JavaSquidSensor(JavaClasspath javaClasspath, SonarComponents sonarComponents, FileSystem fs, DefaultJavaResourceLocator javaResourceLocator, Settings settings, NoSonarFilter noSonarFilter, PostAnalysisIssueFilter postAnalysisIssueFilter) {
        this.noSonarFilter = noSonarFilter;
        this.javaClasspath = javaClasspath;
        this.sonarComponents = sonarComponents;
        this.fs = fs;
        this.javaResourceLocator = javaResourceLocator;
        this.settings = settings;
        this.postAnalysisIssueFilter = postAnalysisIssueFilter;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("java").name("JavaSquidSensor");
    }

    public void execute(SensorContext context) {
        this.javaResourceLocator.setSensorContext(context);
        this.sonarComponents.setSensorContext(context);
        this.sonarComponents.registerCheckClasses("squid", (Iterable)CheckList.getJavaChecks());
        this.sonarComponents.registerTestCheckClasses("squid", (Iterable)CheckList.getJavaTestChecks());
        JavaConfiguration configuration = this.createConfiguration();
        Measurer measurer = new Measurer(this.fs, context, this.noSonarFilter);
        JavaSquid squid = new JavaSquid(configuration, this.sonarComponents, measurer, (JavaResourceLocator)this.javaResourceLocator, (CodeVisitorIssueFilter)this.postAnalysisIssueFilter, this.sonarComponents.checkClasses());
        squid.scan(this.getSourceFiles(), this.getTestFiles(), this.getBytecodeFiles());
    }

    private Iterable<File> getSourceFiles() {
        return JavaSquidSensor.toFile(this.fs.inputFiles(this.fs.predicates().and(this.fs.predicates().hasLanguage("java"), this.fs.predicates().hasType(InputFile.Type.MAIN))));
    }

    private Iterable<File> getTestFiles() {
        return JavaSquidSensor.toFile(this.fs.inputFiles(this.fs.predicates().and(this.fs.predicates().hasLanguage("java"), this.fs.predicates().hasType(InputFile.Type.TEST))));
    }

    private static Iterable<File> toFile(Iterable<InputFile> inputFiles) {
        ArrayList files = Lists.newArrayList();
        for (InputFile inputFile : inputFiles) {
            files.add(inputFile.file());
        }
        return files;
    }

    private List<File> getBytecodeFiles() {
        if (this.settings.getBoolean("sonar.skipDesign")) {
            return Collections.emptyList();
        }
        return this.javaClasspath.getElements();
    }

    private JavaConfiguration createConfiguration() {
        Charset charset = this.fs.encoding();
        JavaConfiguration conf = new JavaConfiguration(charset);
        JavaVersion javaVersion = this.getJavaVersion();
        LOG.info("Configured Java source version (sonar.java.source): " + javaVersion);
        conf.setJavaVersion(javaVersion);
        return conf;
    }

    private JavaVersion getJavaVersion() {
        return JavaVersionImpl.fromString((String)this.settings.getString("sonar.java.source"));
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

