/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="EqEqEq", name="\"===\" and \"!==\" should be used instead of \"==\" and \"!=\"", priority=Priority.MAJOR, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class EqEqEqCheck
extends DoubleDispatchVisitorCheck {
    public void visitBinaryExpression(BinaryExpressionTree tree) {
        if (!EqEqEqCheck.isNullLiteral(tree.leftOperand()) && !EqEqEqCheck.isNullLiteral(tree.rightOperand())) {
            if (tree.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO})) {
                this.addLineIssue((Tree)tree.operator(), "Replace \"==\" with \"===\".");
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.NOT_EQUAL_TO})) {
                this.addLineIssue((Tree)tree.operator(), "Replace \"!=\" with \"!==\".");
            }
        }
        super.visitBinaryExpression(tree);
    }

    private static boolean isNullLiteral(ExpressionTree expressionTree) {
        return expressionTree.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL});
    }
}

