/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.statement.LabelledStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="LabelPlacement", name="Only \"while\", \"do\" and \"for\" statements should be labelled", priority=Priority.MAJOR, tags={"pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="20min")
public class LabelPlacementCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Remove this \"%s\" label.";
    private static final Tree.Kind[] ITERATION_STATEMENTS = new Tree.Kind[]{Tree.Kind.DO_WHILE_STATEMENT, Tree.Kind.WHILE_STATEMENT, Tree.Kind.FOR_IN_STATEMENT, Tree.Kind.FOR_OF_STATEMENT, Tree.Kind.FOR_STATEMENT};

    public void visitLabelledStatement(LabelledStatementTree tree) {
        if (!tree.statement().is(ITERATION_STATEMENTS)) {
            this.addLineIssue((Tree)tree, String.format(MESSAGE, tree.label().name()));
        }
        super.visitLabelledStatement(tree);
    }
}

