/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="VariableShadowing", name="Variables should not be shadowed", priority=Priority.MAJOR, tags={"pitfall"})
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="10min")
public class VariableShadowingCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "\"%s\" hides or potentially hides a variable declared in an outer scope at line %s.";

    public void visitScript(ScriptTree tree) {
        for (Symbol symbol : this.getContext().getSymbolModel().getSymbols()) {
            if (!symbol.isVariable() && !symbol.is(Symbol.Kind.PARAMETER)) continue;
            this.visitSymbol(symbol);
        }
    }

    private void visitSymbol(Symbol symbol) {
        Symbol outerSymbol;
        if ("arguments".equals(symbol.name()) && symbol.builtIn()) {
            return;
        }
        Scope scope = symbol.scope();
        if (scope.outer() != null && (outerSymbol = scope.outer().lookupSymbol(symbol.name())) != null && !outerSymbol.builtIn()) {
            String message = String.format(MESSAGE, symbol.name(), ((JavaScriptTree)VariableShadowingCheck.getDeclaration(outerSymbol).identifierTree()).getLine());
            this.raiseIssuesOnDeclarations(symbol, message);
        }
    }

    private void raiseIssuesOnDeclarations(Symbol symbol, String message) {
        for (Usage usage : symbol.usages()) {
            if (!usage.isDeclaration() && usage.kind() != Usage.Kind.LEXICAL_DECLARATION) continue;
            this.addLineIssue((Tree)usage.identifierTree(), message);
        }
    }

    private static Usage getDeclaration(Symbol symbol) {
        for (Usage usage : symbol.usages()) {
            if (!usage.isDeclaration() && usage.kind() != Usage.Kind.LEXICAL_DECLARATION) continue;
            return usage;
        }
        return (Usage)symbol.usages().iterator().next();
    }
}

