/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks.utils;

import java.util.Iterator;
import javax.annotation.Nullable;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;

public class CheckUtils {
    private CheckUtils() {
    }

    public static String asString(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.TOKEN})) {
            return ((SyntaxToken)tree).text();
        }
        StringBuilder sb = new StringBuilder();
        Iterator treeIterator = ((JavaScriptTree)tree).childrenIterator();
        SyntaxToken prevToken = null;
        while (treeIterator.hasNext()) {
            Tree child = (Tree)treeIterator.next();
            if (child == null) continue;
            CheckUtils.appendChild(sb, prevToken, child);
            prevToken = ((JavaScriptTree)child).getLastToken();
        }
        return sb.toString();
    }

    private static void appendChild(StringBuilder sb, @Nullable SyntaxToken prevToken, Tree child) {
        SyntaxToken firstToken;
        if (prevToken != null && CheckUtils.isSpaceRequired(prevToken, firstToken = ((JavaScriptTree)child).getFirstToken())) {
            sb.append(" ");
        }
        sb.append(CheckUtils.asString(child));
    }

    private static boolean isSpaceRequired(SyntaxToken prevToken, SyntaxToken token) {
        return token.line() > prevToken.line() || prevToken.column() + prevToken.text().length() < token.column();
    }

    public static ExpressionTree removeParenthesis(ExpressionTree expressionTree) {
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.PARENTHESISED_EXPRESSION})) {
            return CheckUtils.removeParenthesis(((ParenthesisedExpressionTree)expressionTree).expression());
        }
        return expressionTree;
    }
}

