/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.impl.statement.IfStatementTreeImpl;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="ElseIfWithoutElse", name="\"if ... else if\" constructs shall be terminated with an \"else\" clause", priority=Priority.MAJOR, tags={"cert", "misra"})
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class ElseIfWithoutElseCheck
extends BaseTreeVisitor {
    public void visitElseClause(ElseClauseTree tree) {
        IfStatementTreeImpl ifStmt;
        if (tree.statement().is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT}) && !(ifStmt = (IfStatementTreeImpl)tree.statement()).hasElse()) {
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)ifStmt, "Add the missing \"else\" clause.");
        }
        super.visitElseClause(tree);
    }
}

