/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1264", name="A \"while\" loop should be used instead of a \"for\" loop", priority=Priority.MINOR, tags={"clumsy"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="5min")
public class ForHidingWhileCheck
extends BaseTreeVisitor {
    public void visitForStatement(ForStatementTree tree) {
        if (tree.init() == null && tree.update() == null) {
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)tree, "Replace this \"for\" loop with a \"while\" loop");
        }
        super.visitForStatement(tree);
    }
}

