/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.MemberExpressionTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionBaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2990", name="The global \"this\" object should not be used", priority=Priority.CRITICAL, tags={"pitfall"})
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="5min")
@ActivatedByDefault
public class GlobalThisCheck
extends SubscriptionBaseTreeVisitor {
    private int scopeLevel = 0;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.FUNCTION_DECLARATION, (Object)Tree.Kind.FUNCTION_EXPRESSION, (Object)Tree.Kind.ARROW_FUNCTION, (Object)Tree.Kind.METHOD, (Object)Tree.Kind.GENERATOR_FUNCTION_EXPRESSION, (Object)Tree.Kind.GET_METHOD, (Object)Tree.Kind.SET_METHOD, (Object)Tree.Kind.GENERATOR_METHOD, (Object)Tree.Kind.GENERATOR_DECLARATION, (Object)Tree.Kind.DOT_MEMBER_EXPRESSION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.DOT_MEMBER_EXPRESSION})) {
            if (((MemberExpressionTree)tree).object().is(new Tree.Kind[]{Tree.Kind.THIS}) && this.scopeLevel == 0) {
                this.getContext().addIssue((JavaScriptCheck)this, tree, "Remove the use of \"this\".");
            }
            return;
        }
        ++this.scopeLevel;
    }

    public void leaveNode(Tree tree) {
        if (!tree.is(new Tree.Kind[]{Tree.Kind.DOT_MEMBER_EXPRESSION})) {
            --this.scopeLevel;
        }
    }
}

