/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionBaseTreeVisitor;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2692", name="\"indexOf\" checks should not be for positive numbers", priority=Priority.MAJOR, tags={"bug"})
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="2min")
public class IndexOfCompareToPositiveNumberCheck
extends SubscriptionBaseTreeVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.GREATER_THAN);
    }

    public void visitNode(Tree tree) {
        BinaryExpressionTree expression = (BinaryExpressionTree)tree;
        if (IndexOfCompareToPositiveNumberCheck.isZero(expression.rightOperand()) && IndexOfCompareToPositiveNumberCheck.isIndexOfCall(expression.leftOperand())) {
            this.addIssue(tree, "0 is a valid index, but is ignored by this check.");
        }
    }

    private static boolean isIndexOfCall(ExpressionTree expression) {
        CallExpressionTree callExpr;
        if (expression.is(new Tree.Kind[]{Tree.Kind.CALL_EXPRESSION}) && (callExpr = (CallExpressionTree)expression).arguments().parameters().size() == 1 && callExpr.callee().is(new Tree.Kind[]{Tree.Kind.DOT_MEMBER_EXPRESSION})) {
            DotMemberExpressionTree memberExpr = (DotMemberExpressionTree)((CallExpressionTree)expression).callee();
            return "indexOf".equals(memberExpr.property().name());
        }
        return false;
    }

    private static boolean isZero(ExpressionTree expression) {
        return expression.is(new Tree.Kind[]{Tree.Kind.NUMERIC_LITERAL}) && "0".equals(((LiteralTree)expression).value());
    }
}

