/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.plugins.javascript.api.visitors.TreeVisitorContext;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="MissingNewlineAtEndOfFile", name="Files should contain an empty new line at the end", priority=Priority.MINOR, tags={"convention"})
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="1min")
public class MissingNewlineAtEndOfFileCheck
extends BaseTreeVisitor {
    public void scanFile(TreeVisitorContext context) {
        super.scanFile(context);
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(this.getContext().getFile(), "r");){
            if (!MissingNewlineAtEndOfFileCheck.endsWithNewline(randomAccessFile)) {
                this.getContext().addFileIssue((JavaScriptCheck)this, "Add a new line at the end of this file.");
            }
        }
        catch (IOException e) {
            String fileName = this.getContext().getFile().getName();
            throw new IllegalStateException("Unable to execute rule \"MissingNewlineAtEndOfFile\" for file " + fileName, e);
        }
    }

    private static boolean endsWithNewline(RandomAccessFile randomAccessFile) throws IOException {
        if (randomAccessFile.length() < 1L) {
            return false;
        }
        randomAccessFile.seek(randomAccessFile.length() - 1L);
        byte[] chars = new byte[1];
        if (randomAccessFile.read(chars) < 1) {
            return false;
        }
        String ch = new String(chars);
        return "\n".equals(ch) || "\r".equals(ch);
    }
}

