/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.AccessorMethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.plugins.javascript.api.visitors.TreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2432", name="Setters should not return values", priority=Priority.CRITICAL, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class ReturnInSetterCheck
extends BaseTreeVisitor {
    private final TreeVisitor forbiddenReturnVisitor = new ForbiddenReturnVisitor();

    public void visitAccessorMethodDeclaration(AccessorMethodDeclarationTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.SET_METHOD})) {
            tree.body().accept(this.forbiddenReturnVisitor);
        }
        super.visitAccessorMethodDeclaration(tree);
    }

    private class ForbiddenReturnVisitor
    extends BaseTreeVisitor {
        private ForbiddenReturnVisitor() {
        }

        public void visitReturnStatement(ReturnStatementTree tree) {
            if (tree.expression() != null) {
                ReturnInSetterCheck check = ReturnInSetterCheck.this;
                check.getContext().addIssue((JavaScriptCheck)check, (Tree)tree, "Remove this return statement.");
            }
            super.visitReturnStatement(tree);
        }
    }
}

