/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.base.Objects;
import java.util.Stack;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.statement.BreakStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ContinueStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.DoWhileStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForInStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForOfStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.LabelledStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.WhileStatementTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.plugins.javascript.api.visitors.TreeVisitorContext;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleLinearRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="TooManyBreakOrContinueInLoop", name="Loops should not contain more than a single \"break\" or \"continue\" statement", priority=Priority.MAJOR, tags={"brain-overload"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleLinearRemediation(coeff="20min", effortToFixDescription="per extra \"break\" or \"continue\" statement")
public class TooManyBreakOrContinueInLoopCheck
extends BaseTreeVisitor {
    private Stack<JumpTarget> jumpTargets = new Stack();

    public void scanFile(TreeVisitorContext context) {
        this.jumpTargets.clear();
        super.scanFile(context);
    }

    public void visitBreakStatement(BreakStatementTree tree) {
        this.increaseNumberOfJumpInScopes(tree.label());
        super.visitBreakStatement(tree);
    }

    public void visitContinueStatement(ContinueStatementTree tree) {
        this.increaseNumberOfJumpInScopes(tree.label());
        super.visitContinueStatement(tree);
    }

    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.enterScope();
        super.visitFunctionExpression(tree);
        this.leaveScope();
    }

    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.enterScope();
        super.visitFunctionDeclaration(tree);
        this.leaveScope();
    }

    public void visitSwitchStatement(SwitchStatementTree tree) {
        this.enterScope();
        super.visitSwitchStatement(tree);
        this.leaveScope();
    }

    public void visitForStatement(ForStatementTree tree) {
        this.enterScope();
        super.visitForStatement(tree);
        this.leaveScopeAndCheckNumberOfJump((Tree)tree);
    }

    public void visitForInStatement(ForInStatementTree tree) {
        this.enterScope();
        super.visitForInStatement(tree);
        this.leaveScopeAndCheckNumberOfJump((Tree)tree);
    }

    public void visitForOfStatement(ForOfStatementTree tree) {
        this.enterScope();
        super.visitForOfStatement(tree);
        this.leaveScopeAndCheckNumberOfJump((Tree)tree);
    }

    public void visitWhileStatement(WhileStatementTree tree) {
        this.enterScope();
        super.visitWhileStatement(tree);
        this.leaveScopeAndCheckNumberOfJump((Tree)tree);
    }

    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        this.enterScope();
        super.visitDoWhileStatement(tree);
        this.leaveScopeAndCheckNumberOfJump((Tree)tree);
    }

    public void visitLabelledStatement(LabelledStatementTree tree) {
        this.jumpTargets.push(new JumpTarget(tree.label().name()));
        super.visitLabelledStatement(tree);
        this.leaveScope();
    }

    private void enterScope() {
        this.jumpTargets.push(new JumpTarget());
    }

    private void leaveScope() {
        this.jumpTargets.pop();
    }

    private void increaseNumberOfJumpInScopes(IdentifierTree label) {
        for (int i = this.jumpTargets.size() - 1; i >= 0; --i) {
            JumpTarget jumpTarget = (JumpTarget)this.jumpTargets.get(i);
            String labelName = label == null ? null : label.name();
            jumpTarget.jumps++;
            if (Objects.equal((Object)labelName, (Object)jumpTarget.label)) break;
        }
    }

    private void leaveScopeAndCheckNumberOfJump(Tree tree) {
        int jumpStatementNumber = this.jumpTargets.pop().jumps;
        if (jumpStatementNumber > 1) {
            this.getContext().addIssue((JavaScriptCheck)this, tree, "Reduce the total number of \"break\" and \"continue\" statements in this loop to use one at most.", (double)jumpStatementNumber - 1.0);
        }
    }

    private static class JumpTarget {
        private final String label;
        private int jumps;

        public JumpTarget() {
            this.label = null;
        }

        public JumpTarget(String label) {
            this.label = label;
        }
    }
}

