/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.InitializedBindingElementTree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2138", name="\"undefined\" should not be assigned", priority=Priority.CRITICAL, tags={"pitfall"})
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="2min")
public class UndefinedAssignmentCheck
extends BaseTreeVisitor {
    public void visitInitializedBindingElement(InitializedBindingElementTree tree) {
        if (UndefinedAssignmentCheck.isUndefined(tree.right())) {
            this.reportIssue((Tree)tree);
        }
        super.visitInitializedBindingElement(tree);
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT}) && UndefinedAssignmentCheck.isUndefined(tree.expression())) {
            this.reportIssue((Tree)tree);
        }
        super.visitAssignmentExpression(tree);
    }

    private static boolean isUndefined(ExpressionTree expression) {
        return expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE}) && "undefined".equals(((IdentifierTree)expression).name());
    }

    private void reportIssue(Tree tree) {
        this.getContext().addIssue((JavaScriptCheck)this, tree, "Use null instead.");
    }
}

