/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.highlighter;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.sonar.sslr.api.Token;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;

public class SourceFileOffsets {
    private final int length;
    private final List<Integer> lineStartOffsets = Lists.newArrayList();

    public SourceFileOffsets(String content) {
        this.length = content.length();
        this.initOffsets(content);
    }

    public SourceFileOffsets(File file, Charset charset) {
        this(SourceFileOffsets.fileContent(file, charset));
    }

    private static String fileContent(File file, Charset charset) {
        String fileContent;
        try {
            fileContent = Files.toString((File)file, (Charset)charset);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read " + file, e);
        }
        return fileContent;
    }

    private void initOffsets(String toParse) {
        this.lineStartOffsets.add(0);
        for (int i = 0; i < this.length; ++i) {
            if (toParse.charAt(i) != '\n' && toParse.charAt(i) != '\r') continue;
            int nextLineStartOffset = i + 1;
            if (i < this.length - 1 && toParse.charAt(i) == '\r' && toParse.charAt(i + 1) == '\n') {
                nextLineStartOffset = i + 2;
                ++i;
            }
            this.lineStartOffsets.add(nextLineStartOffset);
        }
    }

    public int startOffset(Token token) {
        int lineStartOffset = this.lineStartOffsets.get(token.getLine() - 1);
        int column = token.getColumn();
        return lineStartOffset + column;
    }

    public int startOffset(SyntaxToken token) {
        int lineStartOffset = this.lineStartOffsets.get(token.line() - 1);
        int column = token.column();
        return lineStartOffset + column;
    }

    public int endOffset(Token token) {
        return this.startOffset(token) + token.getValue().length();
    }

    public int endOffset(SyntaxToken token) {
        return this.startOffset(token) + token.text().length();
    }
}

