/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.metrics;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.AccessorMethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.GeneratorMethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ConditionalExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.CaseClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.CatchBlockTree;
import org.sonar.plugins.javascript.api.tree.statement.DoWhileStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForInStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForOfStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.IfStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ThrowStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.WhileStatementTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;

public class ComplexityVisitor
extends BaseTreeVisitor {
    private List<Tree> complexityTrees;
    private Set<Tree> excludedReturns;

    public int getComplexity(Tree tree) {
        return this.complexityTrees(tree).size();
    }

    public List<Tree> complexityTrees(Tree tree) {
        this.complexityTrees = new ArrayList<Tree>();
        this.excludedReturns = new HashSet<Tree>();
        this.scan(tree);
        return this.complexityTrees;
    }

    @Override
    public void visitAccessorMethodDeclaration(AccessorMethodDeclarationTree tree) {
        this.excludeLastReturn(tree.body().statements());
        super.visitAccessorMethodDeclaration(tree);
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.add(tree.name());
        this.excludeLastReturn(tree.body().statements());
        super.visitMethodDeclaration(tree);
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.add(tree.functionKeyword());
        this.excludeLastReturn(tree.body().statements());
        super.visitFunctionDeclaration(tree);
    }

    @Override
    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.add(tree.functionKeyword());
        this.excludeLastReturn(tree.body().statements());
        super.visitFunctionExpression(tree);
    }

    @Override
    public void visitGeneratorMethodDeclaration(GeneratorMethodDeclarationTree tree) {
        this.add(tree.name());
        this.excludeLastReturn(tree.body().statements());
        super.visitGeneratorMethodDeclaration(tree);
    }

    @Override
    public void visitIfStatement(IfStatementTree tree) {
        this.add(tree.ifKeyword());
        super.visitIfStatement(tree);
    }

    @Override
    public void visitWhileStatement(WhileStatementTree tree) {
        this.add(tree.whileKeyword());
        super.visitWhileStatement(tree);
    }

    @Override
    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        this.add(tree.doKeyword());
        super.visitDoWhileStatement(tree);
    }

    @Override
    public void visitForStatement(ForStatementTree tree) {
        this.add(tree.forKeyword());
        super.visitForStatement(tree);
    }

    @Override
    public void visitForInStatement(ForInStatementTree tree) {
        this.add(tree.forKeyword());
        super.visitForInStatement(tree);
    }

    @Override
    public void visitForOfStatement(ForOfStatementTree tree) {
        this.add(tree.forKeyword());
        super.visitForOfStatement(tree);
    }

    @Override
    public void visitCaseClause(CaseClauseTree tree) {
        this.add(tree.keyword());
        super.visitCaseClause(tree);
    }

    @Override
    public void visitCatchBlock(CatchBlockTree tree) {
        this.add(tree.catchKeyword());
        super.visitCatchBlock(tree);
    }

    @Override
    public void visitReturnStatement(ReturnStatementTree tree) {
        if (!this.excludedReturns.contains(tree)) {
            this.add(tree.returnKeyword());
        }
        super.visitReturnStatement(tree);
    }

    @Override
    public void visitConditionalExpression(ConditionalExpressionTree tree) {
        this.add(tree.query());
        super.visitConditionalExpression(tree);
    }

    @Override
    public void visitThrowStatement(ThrowStatementTree tree) {
        this.add(tree.throwKeyword());
        super.visitThrowStatement(tree);
    }

    @Override
    public void visitBinaryExpression(BinaryExpressionTree tree) {
        if (tree.is(Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR)) {
            this.add(tree.operator());
        }
        super.visitBinaryExpression(tree);
    }

    private void excludeLastReturn(List<StatementTree> statements) {
        if (statements.isEmpty()) {
            return;
        }
        StatementTree tree = statements.get(statements.size() - 1);
        if (tree.is(Tree.Kind.RETURN_STATEMENT)) {
            this.excludedReturns.add(tree);
        }
    }

    private void add(Tree tree) {
        this.complexityTrees.add(tree);
    }
}

