/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.metrics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sonar.javascript.metrics.MetricsVisitor;
import org.sonar.javascript.tree.visitors.SubscriptionTreeVisitor;
import org.sonar.plugins.javascript.api.tree.Tree;

public class CounterVisitor
extends SubscriptionTreeVisitor {
    private int functionCounter = 0;
    private int statementCounter = 0;
    private int accessorCounter = 0;
    private int classCounter = 0;
    private static final Tree.Kind[] ACCESSOR_NODES = new Tree.Kind[]{Tree.Kind.GET_METHOD, Tree.Kind.SET_METHOD};
    private static final Tree.Kind[] STATEMENT_NODES = new Tree.Kind[]{Tree.Kind.VARIABLE_STATEMENT, Tree.Kind.EMPTY_STATEMENT, Tree.Kind.EXPRESSION_STATEMENT, Tree.Kind.IF_STATEMENT, Tree.Kind.DO_WHILE_STATEMENT, Tree.Kind.WHILE_STATEMENT, Tree.Kind.FOR_IN_STATEMENT, Tree.Kind.FOR_OF_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.CONTINUE_STATEMENT, Tree.Kind.BREAK_STATEMENT, Tree.Kind.RETURN_STATEMENT, Tree.Kind.WITH_STATEMENT, Tree.Kind.SWITCH_STATEMENT, Tree.Kind.THROW_STATEMENT, Tree.Kind.TRY_STATEMENT, Tree.Kind.DEBUGGER_STATEMENT};

    @Override
    public List<Tree.Kind> nodesToVisit() {
        ArrayList<Tree.Kind> result = new ArrayList<Tree.Kind>(Arrays.asList(MetricsVisitor.getFunctionNodes()));
        result.addAll(Arrays.asList(STATEMENT_NODES));
        result.addAll(Arrays.asList(ACCESSOR_NODES));
        result.addAll(Arrays.asList(MetricsVisitor.getClassNodes()));
        return result;
    }

    public CounterVisitor(Tree tree) {
        this.scanTree(tree);
    }

    public int getFunctionNumber() {
        return this.functionCounter;
    }

    public int getStatementsNumber() {
        return this.statementCounter;
    }

    public int getAccessorsNumber() {
        return this.accessorCounter;
    }

    public int getClassNumber() {
        return this.classCounter;
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(MetricsVisitor.getFunctionNodes())) {
            ++this.functionCounter;
        } else if (tree.is(STATEMENT_NODES)) {
            ++this.statementCounter;
        } else if (tree.is(ACCESSOR_NODES)) {
            ++this.accessorCounter;
        } else if (tree.is(MetricsVisitor.getClassNodes())) {
            ++this.classCounter;
        }
    }
}

