/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.impl.lexical;

import com.sonar.sslr.api.TokenType;
import java.util.Iterator;
import java.util.List;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.javascript.api.visitors.TreeVisitor;

public class InternalSyntaxToken
extends JavaScriptTree
implements SyntaxToken {
    private List<SyntaxTrivia> trivias;
    private int startIndex;
    private final int line;
    private final int column;
    private final String value;
    private final boolean isEOF;

    public InternalSyntaxToken(int line, int column, String value, List<SyntaxTrivia> trivias, int startIndex, boolean isEOF) {
        this.value = value;
        this.line = line;
        this.column = column;
        this.trivias = trivias;
        this.startIndex = startIndex;
        this.isEOF = isEOF;
    }

    public int toIndex() {
        return this.startIndex + this.value.length();
    }

    @Override
    public String text() {
        return this.value;
    }

    @Override
    public List<SyntaxTrivia> trivias() {
        return this.trivias;
    }

    @Override
    @Deprecated
    public int getLine() {
        return this.line();
    }

    @Override
    public int line() {
        return this.line;
    }

    @Override
    public int column() {
        return this.column;
    }

    public int startIndex() {
        return this.startIndex;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.TOKEN;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    public boolean isEOF() {
        return this.isEOF;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void accept(TreeVisitor visitor) {
    }

    public boolean is(TokenType type) {
        return this.text().equals(type.getValue());
    }

    @Override
    public SyntaxToken getFirstToken() {
        return this;
    }

    @Override
    public SyntaxToken getLastToken() {
        return this;
    }
}

