/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.impl.statement;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.javascript.tree.impl.statement.BlockTreeImpl;
import org.sonar.javascript.tree.impl.statement.CatchBlockTreeImpl;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.CatchBlockTree;
import org.sonar.plugins.javascript.api.tree.statement.TryStatementTree;
import org.sonar.plugins.javascript.api.visitors.TreeVisitor;

public class TryStatementTreeImpl
extends JavaScriptTree
implements TryStatementTree {
    private SyntaxToken tryKeyword;
    private BlockTree block;
    @Nullable
    private CatchBlockTree catchBlock;
    @Nullable
    private SyntaxToken finallyKeyword;
    @Nullable
    private BlockTree finallyBlock;

    public TryStatementTreeImpl(CatchBlockTreeImpl catchBlock) {
        this.catchBlock = catchBlock;
    }

    public TryStatementTreeImpl(InternalSyntaxToken finallyKeyword, BlockTreeImpl finallyBlock) {
        this.finallyKeyword = finallyKeyword;
        this.finallyBlock = finallyBlock;
    }

    public TryStatementTreeImpl complete(CatchBlockTreeImpl catchBlock) {
        Preconditions.checkState((this.catchBlock == null ? 1 : 0) != 0, (Object)"Catch block already completed");
        this.catchBlock = catchBlock;
        return this;
    }

    public TryStatementTreeImpl complete(InternalSyntaxToken tryKeyword, BlockTreeImpl block) {
        Preconditions.checkState((this.tryKeyword == null ? 1 : 0) != 0, (Object)"Already completed");
        this.tryKeyword = tryKeyword;
        this.block = block;
        return this;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.TRY_STATEMENT;
    }

    @Override
    public SyntaxToken tryKeyword() {
        return this.tryKeyword;
    }

    @Override
    public BlockTree block() {
        return this.block;
    }

    @Override
    @Nullable
    public CatchBlockTree catchBlock() {
        return this.catchBlock;
    }

    @Override
    @Nullable
    public SyntaxToken finallyKeyword() {
        return this.finallyKeyword;
    }

    @Override
    @Nullable
    public BlockTree finallyBlock() {
        return this.finallyBlock;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.tryKeyword, this.block, this.catchBlock, this.finallyKeyword, this.finallyBlock});
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitTryStatement(this);
    }
}

