/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.symbols;

import java.util.List;
import org.sonar.javascript.tree.impl.declaration.InitializedBindingElementTreeImpl;
import org.sonar.javascript.tree.impl.declaration.ParameterListTreeImpl;
import org.sonar.javascript.tree.impl.expression.ArrowFunctionTreeImpl;
import org.sonar.javascript.tree.impl.statement.CatchBlockTreeImpl;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.javascript.tree.symbols.SymbolModelBuilder;
import org.sonar.javascript.tree.symbols.type.ObjectType;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.AccessorMethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.BindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.GeneratorMethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrowFunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.statement.CatchBlockTree;
import org.sonar.plugins.javascript.api.tree.statement.VariableDeclarationTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;

public class SymbolDeclarationVisitor
extends BaseTreeVisitor {
    private SymbolModelBuilder symbolModel;
    private Scope currentScope;

    public SymbolDeclarationVisitor(SymbolModelBuilder symbolModel) {
        this.symbolModel = symbolModel;
        this.currentScope = null;
    }

    @Override
    public void visitScript(ScriptTree tree) {
        this.newScope(tree);
        this.addGlobalBuiltInSymbols();
        super.visitScript(tree);
        this.leaveScope();
    }

    private void addGlobalBuiltInSymbols() {
        this.symbolModel.declareBuiltInSymbol("eval", Symbol.Kind.FUNCTION, this.currentScope);
        Symbol symbol = this.symbolModel.declareBuiltInSymbol("window", Symbol.Kind.VARIABLE, this.currentScope);
        symbol.addType(ObjectType.WebApiType.WINDOW);
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.newScope(tree);
        this.declareParameters(((ParameterListTreeImpl)tree.parameters()).parameterIdentifiers());
        this.addFunctionBuiltInSymbols();
        super.visitMethodDeclaration(tree);
        this.leaveScope();
    }

    @Override
    public void visitAccessorMethodDeclaration(AccessorMethodDeclarationTree tree) {
        this.newScope(tree);
        this.declareParameters(((ParameterListTreeImpl)tree.parameters()).parameterIdentifiers());
        this.addFunctionBuiltInSymbols();
        super.visitAccessorMethodDeclaration(tree);
        this.leaveScope();
    }

    @Override
    public void visitGeneratorMethodDeclaration(GeneratorMethodDeclarationTree tree) {
        this.newScope(tree);
        this.declareParameters(((ParameterListTreeImpl)tree.parameters()).parameterIdentifiers());
        this.addFunctionBuiltInSymbols();
        super.visitGeneratorMethodDeclaration(tree);
        this.leaveScope();
    }

    private void addFunctionBuiltInSymbols() {
        String arguments = "arguments";
        if (this.currentScope.symbols.get(arguments) == null) {
            this.symbolModel.declareBuiltInSymbol(arguments, Symbol.Kind.VARIABLE, this.currentScope);
        }
    }

    @Override
    public void visitCatchBlock(CatchBlockTree tree) {
        this.newScope(tree);
        for (IdentifierTree identifier : ((CatchBlockTreeImpl)tree).parameterIdentifiers()) {
            this.symbolModel.declareSymbol(identifier.name(), Symbol.Kind.VARIABLE, this.currentScope).addUsage(Usage.create(identifier, Usage.Kind.DECLARATION));
        }
        super.visitCatchBlock(tree);
        this.leaveScope();
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.symbolModel.declareSymbol(tree.name().name(), Symbol.Kind.FUNCTION, this.currentScope).addUsage(Usage.create(tree.name(), Usage.Kind.DECLARATION));
        this.newScope(tree);
        this.declareParameters(((ParameterListTreeImpl)tree.parameters()).parameterIdentifiers());
        this.addFunctionBuiltInSymbols();
        super.visitFunctionDeclaration(tree);
        this.leaveScope();
    }

    @Override
    public void visitArrowFunction(ArrowFunctionTree tree) {
        this.newScope(tree);
        this.declareParameters(((ArrowFunctionTreeImpl)tree).parameterIdentifiers());
        this.addFunctionBuiltInSymbols();
        super.visitArrowFunction(tree);
        this.leaveScope();
    }

    @Override
    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.newScope(tree);
        IdentifierTree name = tree.name();
        if (name != null) {
            this.symbolModel.declareSymbol(name.name(), Symbol.Kind.FUNCTION, this.currentScope).addUsage(Usage.create(name, Usage.Kind.DECLARATION));
        }
        this.declareParameters(((ParameterListTreeImpl)tree.parameters()).parameterIdentifiers());
        this.addFunctionBuiltInSymbols();
        super.visitFunctionExpression(tree);
        this.leaveScope();
    }

    @Override
    public void visitVariableDeclaration(VariableDeclarationTree tree) {
        this.addUsages(tree);
        super.visitVariableDeclaration(tree);
    }

    public void addUsages(VariableDeclarationTree tree) {
        for (BindingElementTree bindingElement : tree.variables()) {
            if (bindingElement.is(Tree.Kind.INITIALIZED_BINDING_ELEMENT)) {
                for (IdentifierTree identifier : ((InitializedBindingElementTreeImpl)bindingElement).bindingIdentifiers()) {
                    this.symbolModel.declareSymbol(identifier.name(), Symbol.Kind.VARIABLE, this.currentScope).addUsage(Usage.create(identifier, Usage.Kind.DECLARATION_WRITE));
                }
            }
            if (!(bindingElement instanceof IdentifierTree)) continue;
            IdentifierTree identifierTree = (IdentifierTree)bindingElement;
            this.symbolModel.declareSymbol(identifierTree.name(), Symbol.Kind.VARIABLE, this.currentScope).addUsage(Usage.create(identifierTree, Usage.Kind.DECLARATION));
        }
    }

    private void leaveScope() {
        if (this.currentScope != null) {
            this.currentScope = this.currentScope.outer();
        }
    }

    private void declareParameters(List<IdentifierTree> identifiers) {
        for (IdentifierTree identifier : identifiers) {
            this.symbolModel.declareSymbol(identifier.name(), Symbol.Kind.PARAMETER, this.currentScope).addUsage(Usage.create(identifier, Usage.Kind.LEXICAL_DECLARATION));
        }
    }

    private void newScope(Tree tree) {
        this.currentScope = new Scope(this.currentScope, tree);
        this.symbolModel.addScope(this.currentScope);
    }
}

