/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.symbols.type;

import javax.annotation.Nullable;
import org.sonar.javascript.tree.symbols.type.Utils;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.PairPropertyTree;

public class Backbone {
    private Backbone() {
    }

    public static boolean isModel(CallExpressionTree tree) {
        return Backbone.isModelExtendMethod(tree.callee());
    }

    private static boolean isModelExtendMethod(ExpressionTree tree) {
        DotMemberExpressionTree expr;
        if (tree.is(Tree.Kind.DOT_MEMBER_EXPRESSION) && "extend".equals((expr = (DotMemberExpressionTree)tree).property().name())) {
            if (expr.object().types().contains(Type.Kind.BACKBONE_MODEL)) {
                return true;
            }
            if (expr.object().is(Tree.Kind.DOT_MEMBER_EXPRESSION)) {
                DotMemberExpressionTree subExpr = (DotMemberExpressionTree)expr.object();
                return Utils.identifierWithName(subExpr.object(), "Backbone") && "Model".equals(subExpr.property().name());
            }
        }
        return false;
    }

    @Nullable
    public static PairPropertyTree getModelProperty(ObjectLiteralTree objectLiteral, String propertyName) {
        for (Tree property : objectLiteral.properties()) {
            PairPropertyTree pairProperty;
            if (!property.is(Tree.Kind.PAIR_PROPERTY) || !Utils.identifierWithName((pairProperty = (PairPropertyTree)property).key(), propertyName)) continue;
            return pairProperty;
        }
        return null;
    }
}

