/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonPunctuator;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="BackticksUsage", priority=Priority.MAJOR, name="Backticks should not be used")
@SqaleConstantRemediation(value="5min")
@ActivatedByDefault
public class BackticksUsageCheck
extends PythonCheck {
    public static final String CHECK_KEY = "BackticksUsage";

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.ATOM});
    }

    public void visitNode(AstNode astNode) {
        if (astNode.hasDirectChildren(new AstNodeType[]{PythonPunctuator.BACKTICK})) {
            this.addIssue(astNode, "Use \"repr\" instead.");
        }
    }
}

