/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonMetric;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleLinearWithOffsetRemediation;
import org.sonar.squidbridge.api.SourceFunction;
import org.sonar.squidbridge.measures.MetricDef;

@Rule(key="FunctionComplexity", priority=Priority.MAJOR, name="Functions should not be too complex", tags={"brain-overload"})
@SqaleLinearWithOffsetRemediation(coeff="1min", offset="10min", effortToFixDescription="per complexity point above the threshold")
@ActivatedByDefault
public class FunctionComplexityCheck
extends PythonCheck {
    public static final String CHECK_KEY = "FunctionComplexity";
    private static final int DEFAULT_MAXIMUM_FUNCTION_COMPLEXITY_THRESHOLD = 20;
    private static final String MESSAGE = "Function has a complexity of %s which is greater than %s authorized.";
    @RuleProperty(key="maximumFunctionComplexityThreshold", defaultValue="20")
    private int maximumFunctionComplexityThreshold = 20;

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.FUNCDEF});
    }

    public void leaveNode(AstNode node) {
        SourceFunction function = (SourceFunction)this.getContext().peekSourceCode();
        int complexity = function.getInt((MetricDef)PythonMetric.COMPLEXITY);
        if (complexity > this.maximumFunctionComplexityThreshold) {
            String message = String.format(MESSAGE, complexity, this.maximumFunctionComplexityThreshold);
            this.addIssue(node.getFirstChild(new AstNodeType[]{PythonGrammar.FUNCNAME}), message);
        }
    }

    public void setMaximumFunctionComplexityThreshold(int threshold) {
        this.maximumFunctionComplexityThreshold = threshold;
    }
}

