/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.PythonCheck;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="S1707", priority=Priority.MINOR, name="TODO and FIXME comments should contain a reference to a person", tags={"convention"})
@SqaleConstantRemediation(value="5min")
public class NoPersonReferenceInTodoCheck
extends PythonCheck
implements AstAndTokenVisitor {
    public static final String CHECK_KEY = "S1707";
    public static final String MESSAGE = "Add a citation of the person who can best explain this comment.";
    private static final String DEFAULT_PERSON_REFERENCE_PATTERN = "[ ]*\\([ _a-zA-Z0-9@.]+\\)";
    private static final String COMMENT_PATTERN = "^#[ ]*(todo|fixme)";
    private Pattern patternTodoFixme;
    private Pattern patternPersonReference;
    @RuleProperty(key="pattern", defaultValue="[ ]*\\([ _a-zA-Z0-9@.]+\\)")
    public String personReferencePatternString = "[ ]*\\([ _a-zA-Z0-9@.]+\\)";

    public void visitFile(AstNode astNode) {
        this.patternTodoFixme = Pattern.compile(COMMENT_PATTERN, 2);
        this.patternPersonReference = Pattern.compile(this.personReferencePatternString);
    }

    public void visitToken(Token token) {
        for (Trivia trivia : token.getTrivia()) {
            if (!trivia.isComment()) continue;
            this.visitComment(trivia);
        }
    }

    private void visitComment(Trivia trivia) {
        String tail;
        String comment = trivia.getToken().getValue();
        Matcher matcher = this.patternTodoFixme.matcher(comment);
        if (matcher.find() && !this.patternPersonReference.matcher(tail = comment.substring(matcher.end())).find()) {
            this.addIssue(trivia.getToken(), MESSAGE);
        }
    }
}

