/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.utils.log.Logger;
import org.sonarsource.analyzer.commons.ExternalReportProvider;

public abstract class ExternalIssuesSensor
implements Sensor {
    private static final int MAX_LOGGED_FILE_NAMES = 20;

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyWhenConfiguration(conf -> conf.hasKey(this.reportPathKey())).onlyOnLanguage("py").name("Import of " + this.linterName() + " issues");
    }

    public void execute(SensorContext context) {
        HashSet<String> unresolvedInputFiles = new HashSet<String>();
        List<File> reportFiles = ExternalReportProvider.getReportFiles(context, this.reportPathKey());
        reportFiles.forEach(report -> this.importReport((File)report, context, (Set<String>)unresolvedInputFiles));
        this.logUnresolvedInputFiles(unresolvedInputFiles);
    }

    private void logUnresolvedInputFiles(Set<String> unresolvedInputFiles) {
        if (unresolvedInputFiles.isEmpty()) {
            return;
        }
        String fileList = unresolvedInputFiles.stream().sorted().limit(20L).collect(Collectors.joining(";"));
        if (unresolvedInputFiles.size() > 20) {
            fileList = fileList + ";...";
        }
        this.logger().warn("Failed to resolve {} file path(s) in " + this.linterName() + " report. No issues imported related to file(s): {}", (Object)unresolvedInputFiles.size(), (Object)fileList);
    }

    protected abstract void importReport(File var1, SensorContext var2, Set<String> var3);

    protected abstract String linterName();

    protected abstract String reportPathKey();

    protected abstract Logger logger();
}

