/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.RecognitionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.python.PythonChecks;
import org.sonar.plugins.python.PythonHighlighter;
import org.sonar.plugins.python.PythonScanner;
import org.sonar.plugins.python.Scanner;
import org.sonar.plugins.python.SonarQubePythonFile;
import org.sonar.plugins.python.api.PythonCustomRuleRepository;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.PythonVisitorContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.python.checks.CheckList;
import org.sonar.python.parser.PythonParser;
import org.sonar.python.tree.PythonTreeMaker;

public final class PythonSensor
implements Sensor {
    private final PythonChecks checks;
    private final FileLinesContextFactory fileLinesContextFactory;
    private final NoSonarFilter noSonarFilter;

    public PythonSensor(FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter) {
        this(fileLinesContextFactory, checkFactory, noSonarFilter, null);
    }

    public PythonSensor(FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, @Nullable PythonCustomRuleRepository[] customRuleRepositories) {
        this.checks = new PythonChecks(checkFactory).addChecks("python", CheckList.getChecks()).addCustomChecks(customRuleRepositories);
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.noSonarFilter = noSonarFilter;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("py").name("Python Sensor").onlyOnFileType(InputFile.Type.MAIN);
    }

    public void execute(SensorContext context) {
        List<InputFile> mainFiles = PythonSensor.getInputFiles(InputFile.Type.MAIN, context);
        List<InputFile> testFiles = PythonSensor.getInputFiles(InputFile.Type.TEST, context);
        PythonScanner scanner = new PythonScanner(context, this.checks, this.fileLinesContextFactory, this.noSonarFilter, mainFiles);
        scanner.execute(mainFiles, context);
        if (!testFiles.isEmpty()) {
            new TestHighlightingScanner(context).execute(testFiles, context);
        }
    }

    private static List<InputFile> getInputFiles(InputFile.Type type, SensorContext context) {
        FilePredicates p = context.fileSystem().predicates();
        Iterable it = context.fileSystem().inputFiles(p.and(p.hasType(type), p.hasLanguage("py")));
        ArrayList list = new ArrayList();
        it.forEach(list::add);
        return Collections.unmodifiableList(list);
    }

    private static class TestHighlightingScanner
    extends Scanner {
        private static final Logger LOG = Loggers.get(TestHighlightingScanner.class);
        private final PythonParser parser = PythonParser.create();

        TestHighlightingScanner(SensorContext context) {
            super(context);
        }

        @Override
        protected String name() {
            return "test sources highlighting";
        }

        @Override
        protected void scanFile(InputFile inputFile) throws IOException {
            try {
                PythonFile pythonFile = SonarQubePythonFile.create(inputFile);
                AstNode astNode = this.parser.parse(pythonFile.content());
                FileInput parse = new PythonTreeMaker().fileInput(astNode);
                PythonVisitorContext visitorContext = new PythonVisitorContext(parse, pythonFile, this.context.fileSystem().workDir(), "", new HashMap<String, Set<Symbol>>());
                new PythonHighlighter(this.context, inputFile).scanFile(visitorContext);
            }
            catch (RecognitionException e) {
                LOG.error("Unable to parse file: " + inputFile.toString());
                LOG.error(e.getMessage());
            }
        }

        @Override
        protected void processException(Exception e, InputFile file) {
            LOG.warn("Unable to highlight test file: " + file.toString(), (Throwable)e);
        }
    }
}

