/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.cpd;

import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.TokenType;
import java.util.List;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.cpd.NewCpdTokens;
import org.sonar.plugins.python.api.PythonVisitorContext;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.python.TokenLocation;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.tree.TreeUtils;

public class PythonCpdAnalyzer {
    private final SensorContext context;

    public PythonCpdAnalyzer(SensorContext context) {
        this.context = context;
    }

    public void pushCpdTokens(InputFile inputFile, PythonVisitorContext visitorContext) {
        FileInput root = visitorContext.rootTree();
        if (root != null) {
            NewCpdTokens cpdTokens = this.context.newCpdTokens().onFile(inputFile);
            List<Token> tokens = TreeUtils.tokens(root);
            for (int i = 0; i < tokens.size(); ++i) {
                GenericTokenType nextTokenType;
                Token token = tokens.get(i);
                TokenType currentTokenType = token.type();
                TokenType tokenType = nextTokenType = i + 1 < tokens.size() ? tokens.get(i + 1).type() : GenericTokenType.EOF;
                if (!PythonCpdAnalyzer.isNewLineWithIndentationChange(currentTokenType, nextTokenType) && PythonCpdAnalyzer.isIgnoredType(currentTokenType)) continue;
                TokenLocation location = new TokenLocation(token);
                cpdTokens.addToken(location.startLine(), location.startLineOffset(), location.endLine(), location.endLineOffset(), token.value());
            }
            cpdTokens.save();
        }
    }

    private static boolean isNewLineWithIndentationChange(TokenType currentTokenType, TokenType nextTokenType) {
        return currentTokenType.equals(PythonTokenType.NEWLINE) && nextTokenType.equals(PythonTokenType.DEDENT);
    }

    private static boolean isIgnoredType(TokenType type) {
        return type.equals(PythonTokenType.NEWLINE) || type.equals(PythonTokenType.DEDENT) || type.equals(PythonTokenType.INDENT) || type.equals(GenericTokenType.EOF);
    }
}

