/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.flake8;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class Flake8ReportReader {
    private static final Logger LOG = Loggers.get(Flake8ReportReader.class);
    private static final Pattern DEFAULT_PATTERN = Pattern.compile("(.+):(\\d+):(\\d+): (\\S+) (.*)");
    private static final Pattern PYLINT_PATTERN = Pattern.compile("(.+):(\\d+): \\[(.*)\\] (.*)");

    public List<Issue> parse(File report, FileSystem fileSystem) throws IOException {
        ArrayList<Issue> issues = new ArrayList<Issue>();
        try (Scanner scanner = new Scanner(report.toPath(), fileSystem.encoding().name());){
            while (scanner.hasNextLine()) {
                Issue issue = Flake8ReportReader.parseLine(scanner.nextLine());
                if (issue == null) continue;
                issues.add(issue);
            }
        }
        return issues;
    }

    private static Issue parseLine(String line) {
        if (line.length() > 0) {
            if (!Flake8ReportReader.startsWithWhitespace(line)) {
                Matcher m = DEFAULT_PATTERN.matcher(line);
                if (m.matches()) {
                    String filePath = m.group(1);
                    int lineNumber = Integer.parseInt(m.group(2));
                    int columnNumber = Integer.parseInt(m.group(3));
                    String ruleKey = m.group(4);
                    String message = m.group(5);
                    return new Issue(filePath, ruleKey, message, lineNumber, columnNumber);
                }
                m = PYLINT_PATTERN.matcher(line);
                if (m.matches()) {
                    String filePath = m.group(1);
                    int lineNumber = Integer.parseInt(m.group(2));
                    String ruleKey = m.group(3);
                    String message = m.group(4);
                    return new Issue(filePath, ruleKey, message, lineNumber, null);
                }
                LOG.debug("Cannot parse the line: {}", (Object)line);
            } else {
                LOG.debug("Classifying as detail and ignoring line '{}'", (Object)line);
            }
        }
        return null;
    }

    private static boolean startsWithWhitespace(String line) {
        char first = line.charAt(0);
        return first == ' ' || first == '\t' || first == '\n';
    }

    public static class Issue {
        String filePath;
        String ruleKey;
        String message;
        Integer lineNumber;
        Integer columnNumber;

        public Issue(String filePath, String ruleKey, String message, Integer lineNumber, @Nullable Integer columnNumber) {
            this.filePath = filePath;
            this.ruleKey = ruleKey;
            this.message = message;
            this.lineNumber = lineNumber;
            this.columnNumber = columnNumber;
        }
    }
}

