/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.cfg.CfgBlock;
import org.sonar.plugins.python.api.cfg.ControlFlowGraph;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TryStatement;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S1763")
public class AfterJumpStatementCheck
extends PythonSubscriptionCheck {
    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> {
            FileInput fileInput = (FileInput)ctx.syntaxNode();
            AfterJumpStatementCheck.checkCfg(ControlFlowGraph.build(fileInput, ctx.pythonFile()), ctx, fileInput.statements());
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef functionDef = (FunctionDef)ctx.syntaxNode();
            AfterJumpStatementCheck.checkCfg(ControlFlowGraph.build(functionDef, ctx.pythonFile()), ctx, functionDef.body());
        });
    }

    private static void checkCfg(@Nullable ControlFlowGraph cfg, SubscriptionContext ctx, @Nullable StatementList body) {
        if (cfg == null || body == null) {
            return;
        }
        TryStatementVisitor tryStatementVisitor = new TryStatementVisitor();
        body.accept(tryStatementVisitor);
        if (tryStatementVisitor.hasTryStatementContainingJump) {
            return;
        }
        for (CfgBlock cfgBlock : cfg.blocks()) {
            if (!cfgBlock.predecessors().isEmpty() || cfgBlock.equals(cfg.start()) || cfgBlock.elements().isEmpty()) continue;
            Tree firstElement = cfgBlock.elements().get(0);
            Tree lastElement = cfgBlock.elements().get(cfgBlock.elements().size() - 1);
            PythonCheck.PreciseIssue issue = ctx.addIssue(firstElement.firstToken(), lastElement.lastToken(), "Delete this unreachable code or refactor the code to make it reachable.");
            cfg.blocks().stream().filter(block -> cfgBlock.equals(block.syntacticSuccessor())).map(block -> block.elements().get(block.elements().size() - 1)).forEach(jumpStatement -> issue.secondary((Tree)jumpStatement, null));
        }
    }

    private static class TryStatementVisitor
    extends BaseTreeVisitor {
        boolean hasTryStatementContainingJump = false;

        private TryStatementVisitor() {
        }

        @Override
        public void visitFunctionDef(FunctionDef functionDef) {
        }

        @Override
        public void visitTryStatement(TryStatement tryStatement) {
            if (!this.hasTryStatementContainingJump) {
                this.hasTryStatementContainingJump = TreeUtils.hasDescendant(tryStatement, tree -> tree.is(Tree.Kind.BREAK_STMT, Tree.Kind.CONTINUE_STMT, Tree.Kind.RETURN_STMT));
            }
        }
    }
}

