/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S5655")
public class ArgumentTypeCheck
extends PythonSubscriptionCheck {
    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            CallExpression callExpression = (CallExpression)ctx.syntaxNode();
            Symbol calleeSymbol = callExpression.calleeSymbol();
            if (calleeSymbol == null) {
                return;
            }
            if (!calleeSymbol.is(Symbol.Kind.FUNCTION)) {
                return;
            }
            FunctionSymbol functionSymbol = (FunctionSymbol)calleeSymbol;
            if (functionSymbol.hasVariadicParameter()) {
                return;
            }
            boolean isStaticCall = false;
            if (callExpression.callee().is(Tree.Kind.QUALIFIED_EXPR)) {
                QualifiedExpression qualifiedExpression = (QualifiedExpression)callExpression.callee();
                isStaticCall = TreeUtils.getSymbolFromTree(qualifiedExpression.qualifier()).filter(symbol -> symbol.kind() == Symbol.Kind.CLASS).isPresent();
            }
            ArgumentTypeCheck.checkFunctionCall(ctx, callExpression, functionSymbol, isStaticCall);
        });
    }

    private static void checkFunctionCall(SubscriptionContext ctx, CallExpression callExpression, FunctionSymbol functionSymbol, boolean isStaticCall) {
        boolean isKeyword = false;
        int firstParameterOffset = ArgumentTypeCheck.firstParameterOffset(functionSymbol, isStaticCall);
        if (firstParameterOffset < 0) {
            return;
        }
        for (int i = 0; i < callExpression.arguments().size(); ++i) {
            boolean shouldReport;
            Argument argument = callExpression.arguments().get(i);
            int parameterIndex = i + firstParameterOffset;
            if (parameterIndex >= functionSymbol.parameters().size()) {
                return;
            }
            if (!argument.is(Tree.Kind.REGULAR_ARGUMENT)) continue;
            RegularArgument regularArgument = (RegularArgument)argument;
            boolean bl = shouldReport = (isKeyword |= regularArgument.keywordArgument() != null) ? ArgumentTypeCheck.shouldReportKeywordArgument(regularArgument, functionSymbol) : ArgumentTypeCheck.shouldReportPositionalArgument(regularArgument, functionSymbol, parameterIndex);
            if (!shouldReport) continue;
            ArgumentTypeCheck.reportIssue(ctx, functionSymbol, regularArgument);
        }
    }

    private static boolean shouldReportPositionalArgument(RegularArgument regularArgument, FunctionSymbol functionSymbol, int index) {
        FunctionSymbol.Parameter functionParameter = functionSymbol.parameters().get(index);
        InferredType argumentType = regularArgument.expression().type();
        InferredType parameterType = functionParameter.declaredType();
        if (parameterType.canOnlyBe("object")) {
            return false;
        }
        return ArgumentTypeCheck.isIncompatibleTypes(argumentType, parameterType);
    }

    private static boolean shouldReportKeywordArgument(RegularArgument regularArgument, FunctionSymbol functionSymbol) {
        Name keywordArgument = regularArgument.keywordArgument();
        InferredType argumentType = regularArgument.expression().type();
        if (keywordArgument == null) {
            return false;
        }
        String keywordName = keywordArgument.name();
        Optional<FunctionSymbol.Parameter> correspondingParameter = functionSymbol.parameters().stream().filter(p -> keywordName.equals(p.name())).findFirst();
        return correspondingParameter.map(c -> {
            InferredType parameterType = c.declaredType();
            return ArgumentTypeCheck.isIncompatibleTypes(argumentType, parameterType);
        }).orElse(false);
    }

    private static void reportIssue(SubscriptionContext ctx, FunctionSymbol functionSymbol, RegularArgument regularArgument) {
        PythonCheck.PreciseIssue issue = ctx.addIssue(regularArgument, String.format("Change this argument; Function \"%s\" expects a different type", functionSymbol.name()));
        LocationInFile locationInFile = functionSymbol.definitionLocation();
        if (locationInFile != null) {
            issue.secondary(locationInFile, "Function definition");
        }
    }

    private static boolean isIncompatibleTypes(InferredType argumentType, InferredType parameterType) {
        return (ArgumentTypeCheck.isNotDuckTypeCompatible(argumentType, parameterType) || !argumentType.isCompatibleWith(parameterType) && !ArgumentTypeCheck.couldBeDuckTypeCompatible(argumentType, parameterType)) && !ArgumentTypeCheck.isException(argumentType);
    }

    private static boolean isNotDuckTypeCompatible(InferredType argumentType, InferredType parameterType) {
        String firstBuiltin = ArgumentTypeCheck.matchBuiltinCategory(argumentType::canOnlyBe);
        String secondBuiltin = ArgumentTypeCheck.matchBuiltinCategory(parameterType::canOnlyBe);
        return firstBuiltin != null && secondBuiltin != null && !firstBuiltin.equals(secondBuiltin);
    }

    private static boolean couldBeDuckTypeCompatible(InferredType firstType, InferredType secondType) {
        String firstPossibleBuiltin = ArgumentTypeCheck.matchBuiltinCategory(firstType::canBeOrExtend);
        String secondPossibleBuiltin = ArgumentTypeCheck.matchBuiltinCategory(secondType::canBeOrExtend);
        return firstPossibleBuiltin != null && firstPossibleBuiltin.equals(secondPossibleBuiltin);
    }

    public static String matchBuiltinCategory(Predicate<String> predicate) {
        if (predicate.test("str")) {
            return "str";
        }
        if (predicate.test("int") || predicate.test("float") || predicate.test("complex") || predicate.test("bool")) {
            return "number";
        }
        if (predicate.test("list")) {
            return "list";
        }
        if (predicate.test("set")) {
            return "set";
        }
        if (predicate.test("dict")) {
            return "dict";
        }
        if (predicate.test("tuple")) {
            return "tuple";
        }
        return null;
    }

    private static int firstParameterOffset(FunctionSymbol functionSymbol, boolean isStaticCall) {
        List<FunctionSymbol.Parameter> parameters = functionSymbol.parameters();
        if (parameters.isEmpty()) {
            return 0;
        }
        String firstParamName = parameters.get(0).name();
        if (firstParamName == null) {
            return -1;
        }
        List<String> decoratorNames = functionSymbol.decorators();
        if (decoratorNames.size() > 1) {
            return -1;
        }
        if (functionSymbol.isInstanceMethod() && !isStaticCall) {
            return 1;
        }
        if (decoratorNames.size() == 1 && decoratorNames.get(0).endsWith("classmethod")) {
            return 1;
        }
        if (!functionSymbol.isInstanceMethod()) {
            return 0;
        }
        return -1;
    }

    private static boolean isException(InferredType inferredType) {
        return SymbolUtils.externalModulesSymbols().values().stream().flatMap(Collection::stream).anyMatch(symbol -> inferredType.canBeOrExtend(symbol.fullyQualifiedName())) || inferredType.canBeOrExtend("unittest.mock.Mock");
    }
}

