/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.ExceptClause;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.RaiseStatement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TryStatement;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S5754")
public class IgnoredSystemExitCheck
extends PythonSubscriptionCheck {
    private static final String BASE_EXCEPTION_NAME = "BaseException";
    private static final String SYSTEM_EXIT_EXCEPTION_NAME = "SystemExit";
    private static final String MESSAGE_NOT_RERAISED_CAUGHT_EXCEPTION = "Reraise this exception to stop the application as the user expects";
    private static final String MESSAGE_BARE_EXCEPT = "Specify an exception class to catch or reraise the exception";
    private static final String MESSAGE_NOT_RERAISED_BASE_EXCEPTION = "Catch a more specific exception or reraise the exception";
    private static final String SYSTEM_EXIT_FUNCTION_NAME = "sys.exit";
    private static final String SYSTEM_EXC_INFO_NAME = "sys.exc_info";

    @CheckForNull
    private static Symbol findExceptionInstanceSymbol(@Nullable Expression exceptionInstance) {
        Symbol exceptionInstanceSymbol = null;
        if (exceptionInstance instanceof HasSymbol) {
            exceptionInstanceSymbol = ((HasSymbol)((Object)exceptionInstance)).symbol();
        }
        return exceptionInstanceSymbol;
    }

    @CheckForNull
    private static String findExceptionName(Expression exception) {
        Symbol exceptionSymbol;
        if (exception instanceof HasSymbol && (exceptionSymbol = ((HasSymbol)((Object)exception)).symbol()) != null) {
            return exceptionSymbol.fullyQualifiedName();
        }
        return null;
    }

    private static void handlePossibleBareException(SubscriptionContext ctx, ExceptClause exceptClause, boolean isSystemExitHandled) {
        ExceptionReRaiseCheckVisitor visitor = new ExceptionReRaiseCheckVisitor(null);
        exceptClause.accept(visitor);
        if (!visitor.isReRaised && !isSystemExitHandled) {
            ctx.addIssue(exceptClause.exceptKeyword(), MESSAGE_BARE_EXCEPT);
        }
    }

    private static boolean handleCaughtException(SubscriptionContext ctx, Expression caughtException, @Nullable Symbol exceptionInstanceSymbol, Tree exceptionBody, boolean handledSystemExit) {
        String caughtExceptionName = IgnoredSystemExitCheck.findExceptionName(caughtException);
        if (caughtExceptionName == null) {
            return false;
        }
        ExceptionReRaiseCheckVisitor visitor = new ExceptionReRaiseCheckVisitor(exceptionInstanceSymbol);
        exceptionBody.accept(visitor);
        if (visitor.isReRaised) {
            return SYSTEM_EXIT_EXCEPTION_NAME.equals(caughtExceptionName);
        }
        if (SYSTEM_EXIT_EXCEPTION_NAME.equals(caughtExceptionName)) {
            ctx.addIssue(caughtException, MESSAGE_NOT_RERAISED_CAUGHT_EXCEPTION);
            return true;
        }
        if (BASE_EXCEPTION_NAME.equals(caughtExceptionName) && !handledSystemExit) {
            ctx.addIssue(caughtException, MESSAGE_NOT_RERAISED_BASE_EXCEPTION);
        }
        return false;
    }

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.TRY_STMT, ctx -> {
            TryStatement tryStatement = (TryStatement)ctx.syntaxNode();
            boolean isSystemExitHandled = false;
            for (ExceptClause exceptClause : tryStatement.exceptClauses()) {
                Expression exceptionExpr = exceptClause.exception();
                if (exceptionExpr == null) {
                    IgnoredSystemExitCheck.handlePossibleBareException(ctx, exceptClause, isSystemExitHandled);
                    break;
                }
                Expression exceptionInstance = exceptClause.exceptionInstance();
                Symbol exceptionInstanceSymbol = IgnoredSystemExitCheck.findExceptionInstanceSymbol(exceptionInstance);
                List caughtExceptions = TreeUtils.flattenTuples(exceptionExpr).collect(Collectors.toList());
                for (Expression caughtException : caughtExceptions) {
                    isSystemExitHandled |= IgnoredSystemExitCheck.handleCaughtException(ctx, caughtException, exceptionInstanceSymbol, exceptClause.body(), isSystemExitHandled);
                }
            }
        });
    }

    private static class ExceptionReRaiseCheckVisitor
    extends BaseTreeVisitor {
        private Symbol exceptionInstance;
        private boolean isReRaised;

        public ExceptionReRaiseCheckVisitor(@Nullable Symbol exceptionInstance) {
            this.exceptionInstance = exceptionInstance;
        }

        @Override
        public void visitRaiseStatement(RaiseStatement pyRaiseStatementTree) {
            if (pyRaiseStatementTree.expressions().isEmpty()) {
                this.isReRaised = true;
                return;
            }
            Expression raisedException = pyRaiseStatementTree.expressions().get(0);
            if (raisedException.type().canOnlyBe(IgnoredSystemExitCheck.SYSTEM_EXIT_EXCEPTION_NAME)) {
                this.isReRaised = true;
            }
            if (raisedException instanceof HasSymbol) {
                Symbol symbol = ((HasSymbol)((Object)raisedException)).symbol();
                if (symbol == null) {
                    return;
                }
                if (symbol.equals(this.exceptionInstance)) {
                    this.isReRaised = true;
                }
            }
        }

        @Override
        public void visitCallExpression(CallExpression pyCallExpressionTree) {
            Symbol symbol = pyCallExpressionTree.calleeSymbol();
            if (symbol == null) {
                return;
            }
            String fqn = symbol.fullyQualifiedName();
            this.isReRaised |= IgnoredSystemExitCheck.SYSTEM_EXIT_FUNCTION_NAME.equals(fqn);
            this.isReRaised |= IgnoredSystemExitCheck.SYSTEM_EXC_INFO_NAME.equals(fqn);
        }
    }
}

