/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.ArgList;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.Expressions;

@Rule(key="S4433")
public class LdapAuthenticationCheck
extends PythonSubscriptionCheck {
    private static final Set<String> LDAP_OBJECT_SENSITIVE_METHODS = new HashSet<String>(Arrays.asList("ldap.LDAPObject.simple_bind", "ldap.LDAPObject.simple_bind_s", "ldap.LDAPObject.bind", "ldap.LDAPObject.bind_s"));

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            CallExpression callExpression = (CallExpression)ctx.syntaxNode();
            Symbol calleeSymbol = callExpression.calleeSymbol();
            HashSet<Tree> secondaries = new HashSet<Tree>();
            if (calleeSymbol != null && LDAP_OBJECT_SENSITIVE_METHODS.contains(calleeSymbol.fullyQualifiedName()) && !LdapAuthenticationCheck.isPasswordProvided(callExpression.argumentList(), secondaries)) {
                PythonCheck.PreciseIssue preciseIssue = ctx.addIssue(callExpression.callee(), "Provide a password when authenticating to this LDAP server.");
                secondaries.forEach(secondary -> preciseIssue.secondary((Tree)secondary, null));
            }
        });
    }

    private static boolean isPasswordProvided(@Nullable ArgList argList, Set<Tree> secondaries) {
        if (argList == null) {
            return false;
        }
        for (int i = 0; i < argList.arguments().size(); ++i) {
            if (argList.arguments().get(i).is(Tree.Kind.UNPACKING_EXPR)) {
                return true;
            }
            RegularArgument regularArgument = (RegularArgument)argList.arguments().get(i);
            Name keyword = regularArgument.keywordArgument();
            if ((keyword != null || i != 1) && (keyword == null || !keyword.name().equals("cred"))) continue;
            if (LdapAuthenticationCheck.isValidPassword(regularArgument.expression(), secondaries)) {
                return true;
            }
            secondaries.add(regularArgument.expression());
            return false;
        }
        return false;
    }

    private static boolean isValidPassword(Expression expression, Set<Tree> secondaries) {
        Expression singleAssignedValue;
        if (LdapAuthenticationCheck.isNoneOrEmptyString(expression, secondaries)) {
            return false;
        }
        if (expression.is(Tree.Kind.NAME) && (singleAssignedValue = Expressions.singleAssignedValue((Name)expression)) != null) {
            return !LdapAuthenticationCheck.isNoneOrEmptyString(singleAssignedValue, secondaries);
        }
        return true;
    }

    private static boolean isNoneOrEmptyString(Expression expression, Set<Tree> secondaries) {
        if (expression.type().canOnlyBe("NoneType") || expression.is(Tree.Kind.STRING_LITERAL) && ((StringLiteral)expression).trimmedQuotesValue().isEmpty()) {
            secondaries.add(expression);
            return true;
        }
        return false;
    }
}

