/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.CompoundAssignmentStatement;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S5717")
public class ModifiedParameterValueCheck
extends PythonSubscriptionCheck {
    private static final Set<String> COMMON_MUTATING_METHODS = new HashSet<String>(Arrays.asList("__delitem__", "__setitem__"));
    private static final String CLEAR = "clear";
    private static final Set<String> LIST_MUTATING_METHODS = new HashSet<String>(Arrays.asList("append", "clear", "extend", "insert", "pop", "remove", "reverse", "sort"));
    private static final Set<String> SET_MUTATING_METHODS = new HashSet<String>(Arrays.asList("update", "intersection_update", "difference_update", "symmetric_difference_update", "add", "remove", "discard", "pop", "clear"));
    private static final Set<String> DICT_MUTATING_METHODS = new HashSet<String>(Arrays.asList("pop", "clear", "popitem", "setdefault", "update"));
    private static final Set<String> DEQUE_MUTATING_METHODS = new HashSet<String>(Arrays.asList("appendleft", "extendleft", "popleft", "rotate"));
    private static final Set<String> COUNTER_MUTATING_METHODS;
    private static final Set<String> ORDERED_DICT_MUTATING_METHODS;
    private static final Set<String> DEFAULT_DICT_MUTATING_METHODS;
    private static final Map<String, Set<String>> MUTATING_METHODS;

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef functionDef = (FunctionDef)ctx.syntaxNode();
            if (TreeUtils.firstAncestorOfKind(functionDef, Tree.Kind.FUNCDEF) != null) {
                return;
            }
            for (Parameter parameter : TreeUtils.nonTupleParameters(functionDef)) {
                List<Tree> mutations = ModifiedParameterValueCheck.getMutations(parameter);
                if (mutations.isEmpty()) continue;
                PythonCheck.PreciseIssue preciseIssue = ctx.addIssue(parameter, "Change this default value to \"None\" and initialize this parameter inside the function/method.");
                mutations.forEach(mutation -> preciseIssue.secondary((Tree)mutation, null));
            }
        });
    }

    @CheckForNull
    private static String defaultValueType(Expression expression) {
        for (String nonCompliantType : MUTATING_METHODS.keySet()) {
            if (!expression.type().canOnlyBe(nonCompliantType)) continue;
            return nonCompliantType;
        }
        return null;
    }

    private static boolean isUsingMemoization(Symbol symbol) {
        return symbol.name().contains("cache") || symbol.name().contains("memo");
    }

    private static List<Tree> getMutations(Parameter parameter) {
        List<Tree> attributeSet;
        Expression defaultValue = parameter.defaultValue();
        if (defaultValue == null) {
            return Collections.emptyList();
        }
        Optional<Symbol> paramSymbol = TreeUtils.getSymbolFromTree(parameter.name());
        if (!paramSymbol.isPresent() || ModifiedParameterValueCheck.isUsingMemoization(paramSymbol.get())) {
            return Collections.emptyList();
        }
        if (!defaultValue.type().canOnlyBe("NoneType") && !(attributeSet = ModifiedParameterValueCheck.getAttributeSet(paramSymbol.get())).isEmpty()) {
            return attributeSet;
        }
        String defaultValueType = ModifiedParameterValueCheck.defaultValueType(defaultValue);
        Set<String> typeMutatingMethods = MUTATING_METHODS.get(defaultValueType);
        if (typeMutatingMethods == null) {
            return Collections.emptyList();
        }
        return paramSymbol.get().usages().stream().filter(usage -> ModifiedParameterValueCheck.isWriteUsage(paramSymbol, defaultValueType, typeMutatingMethods, usage)).map(usage -> usage.tree().parent()).collect(Collectors.toList());
    }

    private static boolean isWriteUsage(Optional<Symbol> paramSymbol, @Nullable String defaultValueType, Set<String> typeMutatingMethods, Usage usage) {
        Tree parent = usage.tree().parent();
        if (parent.is(Tree.Kind.QUALIFIED_EXPR)) {
            QualifiedExpression qualifiedExpression = (QualifiedExpression)parent;
            return TreeUtils.getSymbolFromTree(qualifiedExpression.qualifier()).equals(paramSymbol) && ModifiedParameterValueCheck.isMutatingMethod(typeMutatingMethods, qualifiedExpression.name().name());
        }
        return ModifiedParameterValueCheck.isUsedInDelStatement(usage.tree()) || ModifiedParameterValueCheck.isUsedInLhsOfAssignment(usage.tree(), exp -> ModifiedParameterValueCheck.isAccessingExpression(exp, usage.tree())) || ModifiedParameterValueCheck.isUsedInLhsOfCompoundAssignment(usage.tree()) || ModifiedParameterValueCheck.isGetItemOnDefaultDict(defaultValueType, usage.tree()) || ModifiedParameterValueCheck.mightBeReferencedOutsideOfFunction(usage.tree());
    }

    private static boolean isAccessingExpression(Expression expression, Tree tree) {
        return ModifiedParameterValueCheck.isObjectOfSubscription(tree, expression) || ModifiedParameterValueCheck.isQualifier(tree, expression);
    }

    private static boolean mightBeReferencedOutsideOfFunction(Tree tree) {
        AssignmentStatement assignment = (AssignmentStatement)TreeUtils.firstAncestorOfKind(tree, Tree.Kind.ASSIGNMENT_STMT);
        if (assignment == null) {
            return false;
        }
        return assignment.assignedValue() == tree && assignment.lhsExpressions().stream().flatMap(expressionList -> expressionList.expressions().stream()).anyMatch(ModifiedParameterValueCheck::isAccessingSelf);
    }

    private static boolean isAccessingSelf(Expression expression) {
        switch (expression.getKind()) {
            case QUALIFIED_EXPR: {
                return ModifiedParameterValueCheck.isSelf(((QualifiedExpression)expression).qualifier());
            }
            case SUBSCRIPTION: {
                return ModifiedParameterValueCheck.isSelf(((SubscriptionExpression)expression).object());
            }
        }
        return false;
    }

    private static boolean isSelf(Expression expression) {
        return expression.is(Tree.Kind.NAME) && ((Name)expression).name().equals("self");
    }

    private static List<Tree> getAttributeSet(Symbol paramSymbol) {
        return paramSymbol.usages().stream().map(Usage::tree).filter(tree -> ModifiedParameterValueCheck.isUsedInLhsOfAssignment(tree, expression -> ModifiedParameterValueCheck.isQualifier(tree, expression))).collect(Collectors.toList());
    }

    private static boolean isUsedInLhsOfCompoundAssignment(Tree tree) {
        CompoundAssignmentStatement compoundAssignmentStatement = (CompoundAssignmentStatement)TreeUtils.firstAncestorOfKind(tree, Tree.Kind.COMPOUND_ASSIGNMENT);
        return compoundAssignmentStatement != null && ModifiedParameterValueCheck.isAccessingExpression(compoundAssignmentStatement.lhsExpression(), tree);
    }

    private static boolean isGetItemOnDefaultDict(@Nullable String defaultValueType, Tree tree) {
        return "collections.defaultdict".equals(defaultValueType) && ModifiedParameterValueCheck.isObjectOfSubscription(tree, tree.parent());
    }

    private static boolean isObjectOfSubscription(Tree usageTree, Tree tree) {
        return tree.is(Tree.Kind.SUBSCRIPTION) && ((SubscriptionExpression)tree).object() == usageTree;
    }

    private static boolean isQualifier(Tree usageTree, Tree tree) {
        return tree.is(Tree.Kind.QUALIFIED_EXPR) && ((QualifiedExpression)tree).qualifier() == usageTree;
    }

    private static boolean isUsedInLhsOfAssignment(Tree tree, Predicate<Expression> lhsPredicate) {
        AssignmentStatement assignment = (AssignmentStatement)TreeUtils.firstAncestorOfKind(tree, Tree.Kind.ASSIGNMENT_STMT);
        if (assignment == null) {
            return false;
        }
        return assignment.lhsExpressions().stream().flatMap(expressionList -> expressionList.expressions().stream()).anyMatch(lhsPredicate);
    }

    private static boolean isUsedInDelStatement(Tree tree) {
        return TreeUtils.firstAncestorOfKind(tree, Tree.Kind.DEL_STMT) != null;
    }

    private static boolean isMutatingMethod(Set<String> typeMutatingMethods, String method) {
        return typeMutatingMethods.contains(method) || COMMON_MUTATING_METHODS.contains(method) || method.startsWith("__i") && method.endsWith("__");
    }

    static {
        DEQUE_MUTATING_METHODS.addAll(LIST_MUTATING_METHODS);
        COUNTER_MUTATING_METHODS = new HashSet<String>();
        COUNTER_MUTATING_METHODS.add("subtract");
        COUNTER_MUTATING_METHODS.addAll(DICT_MUTATING_METHODS);
        ORDERED_DICT_MUTATING_METHODS = new HashSet<String>();
        ORDERED_DICT_MUTATING_METHODS.add("move_to_end");
        ORDERED_DICT_MUTATING_METHODS.addAll(DICT_MUTATING_METHODS);
        DEFAULT_DICT_MUTATING_METHODS = new HashSet<String>();
        DEFAULT_DICT_MUTATING_METHODS.add("__getitem__");
        DEFAULT_DICT_MUTATING_METHODS.addAll(DICT_MUTATING_METHODS);
        MUTATING_METHODS = new HashMap<String, Set<String>>();
        MUTATING_METHODS.put("list", LIST_MUTATING_METHODS);
        MUTATING_METHODS.put("set", SET_MUTATING_METHODS);
        MUTATING_METHODS.put("dict", DICT_MUTATING_METHODS);
        MUTATING_METHODS.put("collections.deque", DEQUE_MUTATING_METHODS);
        MUTATING_METHODS.put("collections.UserList", LIST_MUTATING_METHODS);
        MUTATING_METHODS.put("collections.UserDict", DICT_MUTATING_METHODS);
        MUTATING_METHODS.put("collections.ChainMap", DICT_MUTATING_METHODS);
        MUTATING_METHODS.put("collections.Counter", COUNTER_MUTATING_METHODS);
        MUTATING_METHODS.put("collections.OrderedDict", ORDERED_DICT_MUTATING_METHODS);
        MUTATING_METHODS.put("collections.defaultdict", DEFAULT_DICT_MUTATING_METHODS);
    }
}

