/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic;

import java.io.File;
import java.net.URI;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.ArgList;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.ListLiteral;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.ParenthesizedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Tuple;
import org.sonar.plugins.python.api.tree.UnpackingExpression;
import org.sonar.python.semantic.ClassSymbolImpl;
import org.sonar.python.semantic.FunctionSymbolImpl;
import org.sonar.python.semantic.SymbolImpl;
import org.sonar.python.semantic.SymbolTableBuilder;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.InferredTypes;
import org.sonar.python.types.TypeShedPythonFile;

public class SymbolUtils {
    private static final String SEND_MESSAGE = "send_message";
    private static final String SET_COOKIE = "set_cookie";
    private static final String SET_SIGNED_COOKIE = "set_signed_cookie";
    private static final String EQ = "__eq__";
    private static final String SET_VERIFY = "set_verify";

    private SymbolUtils() {
    }

    public static String fullyQualifiedModuleName(String packageName, String fileName) {
        String moduleName;
        int extensionIndex = fileName.lastIndexOf(46);
        String string = moduleName = extensionIndex > 0 ? fileName.substring(0, extensionIndex) : fileName;
        if (moduleName.equals("__init__")) {
            return packageName;
        }
        return packageName.isEmpty() ? moduleName : packageName + "." + moduleName;
    }

    public static Set<Symbol> globalSymbols(FileInput fileInput, String packageName, PythonFile pythonFile) {
        SymbolTableBuilder symbolTableBuilder = new SymbolTableBuilder(packageName, pythonFile);
        String fullyQualifiedModuleName = SymbolUtils.fullyQualifiedModuleName(packageName, pythonFile.fileName());
        fileInput.accept(symbolTableBuilder);
        HashSet<Symbol> globalSymbols = new HashSet<Symbol>();
        for (Symbol globalVariable : fileInput.globalVariables()) {
            String fullyQualifiedVariableName = globalVariable.fullyQualifiedName();
            if (fullyQualifiedVariableName != null && !fullyQualifiedVariableName.startsWith(fullyQualifiedModuleName) || globalVariable.usages().stream().anyMatch(u -> u.kind().equals((Object)Usage.Kind.IMPORT))) continue;
            if (globalVariable.kind() == Symbol.Kind.CLASS) {
                globalSymbols.add(((ClassSymbolImpl)globalVariable).copyWithoutUsages());
                continue;
            }
            if (globalVariable.kind() == Symbol.Kind.FUNCTION) {
                globalSymbols.add(new FunctionSymbolImpl(globalVariable.name(), (FunctionSymbol)globalVariable));
                continue;
            }
            globalSymbols.add(new SymbolImpl(globalVariable.name(), fullyQualifiedModuleName + "." + globalVariable.name()));
        }
        return globalSymbols;
    }

    static void resolveTypeHierarchy(ClassDef classDef, @Nullable Symbol symbol, PythonFile pythonFile, Map<String, Symbol> symbolsByName) {
        if (symbol == null || !Symbol.Kind.CLASS.equals((Object)symbol.kind())) {
            return;
        }
        ClassSymbolImpl classSymbol = (ClassSymbolImpl)symbol;
        if (SymbolUtils.isBuiltinTypeshedFile(pythonFile) && "str".equals(classSymbol.fullyQualifiedName())) {
            classSymbol.addSuperClass(symbolsByName.get("object"));
            classSymbol.addSuperClass(symbolsByName.get("Sequence"));
            return;
        }
        ArgList argList = classDef.args();
        if (argList == null) {
            return;
        }
        for (Argument argument : argList.arguments()) {
            Symbol argumentSymbol = SymbolUtils.getSymbolFromArgument(argument);
            if (argumentSymbol == null) {
                classSymbol.setHasSuperClassWithoutSymbol();
                continue;
            }
            Symbol normalizedArgumentSymbol = SymbolUtils.normalizeSymbol(argumentSymbol, pythonFile, symbolsByName);
            if (normalizedArgumentSymbol == null) continue;
            classSymbol.addSuperClass(normalizedArgumentSymbol);
        }
    }

    @CheckForNull
    private static Symbol normalizeSymbol(Symbol symbol, PythonFile pythonFile, Map<String, Symbol> symbolsByName) {
        if (SymbolUtils.isTypeShedFile(pythonFile) && (symbol.name().equals("Protocol") || symbol.name().equals("Generic"))) {
            return null;
        }
        if (SymbolUtils.isTypingFile(pythonFile) && symbol.name().equals("_Collection")) {
            return symbolsByName.get("Collection");
        }
        return symbol;
    }

    private static boolean isBuiltinTypeshedFile(PythonFile pythonFile) {
        return SymbolUtils.isTypeShedFile(pythonFile) && pythonFile.fileName().isEmpty();
    }

    private static boolean isTypingFile(PythonFile pythonFile) {
        return SymbolUtils.isTypeShedFile(pythonFile) && pythonFile.fileName().equals("typing");
    }

    @CheckForNull
    private static Symbol getSymbolFromArgument(Argument argument) {
        if (argument.is(Tree.Kind.REGULAR_ARGUMENT)) {
            Expression expression = ((RegularArgument)argument).expression();
            while (expression.is(Tree.Kind.SUBSCRIPTION)) {
                expression = ((SubscriptionExpression)expression).object();
            }
            if (expression instanceof HasSymbol) {
                return ((HasSymbol)((Object)expression)).symbol();
            }
        }
        return null;
    }

    public static List<Expression> assignmentsLhs(AssignmentStatement assignmentStatement) {
        return assignmentStatement.lhsExpressions().stream().flatMap(exprList -> exprList.expressions().stream()).flatMap(TreeUtils::flattenTuples).collect(Collectors.toList());
    }

    static List<Name> boundNamesFromExpression(@CheckForNull Tree tree) {
        ArrayList<Name> names = new ArrayList<Name>();
        if (tree == null) {
            return names;
        }
        if (tree.is(Tree.Kind.NAME)) {
            names.add((Name)tree);
        } else if (tree.is(Tree.Kind.TUPLE)) {
            ((Tuple)tree).elements().forEach(t -> names.addAll(SymbolUtils.boundNamesFromExpression(t)));
        } else if (tree.is(Tree.Kind.LIST_LITERAL)) {
            ((ListLiteral)tree).elements().expressions().forEach(t -> names.addAll(SymbolUtils.boundNamesFromExpression(t)));
        } else if (tree.is(Tree.Kind.PARENTHESIZED)) {
            names.addAll(SymbolUtils.boundNamesFromExpression(((ParenthesizedExpression)tree).expression()));
        } else if (tree.is(Tree.Kind.UNPACKING_EXPR)) {
            names.addAll(SymbolUtils.boundNamesFromExpression(((UnpackingExpression)tree).expression()));
        }
        return names;
    }

    public static String pythonPackageName(File file, File projectBaseDir) {
        File initFile;
        File currentDirectory = file.getParentFile();
        ArrayDeque<String> packages = new ArrayDeque<String>();
        while (!currentDirectory.getAbsolutePath().equals(projectBaseDir.getAbsolutePath()) && (initFile = new File(currentDirectory, "__init__.py")).exists()) {
            packages.push(currentDirectory.getName());
            currentDirectory = currentDirectory.getParentFile();
        }
        return String.join((CharSequence)".", packages);
    }

    @CheckForNull
    static Path pathOf(PythonFile pythonFile) {
        try {
            URI uri = pythonFile.uri();
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                return Paths.get(uri);
            }
            return null;
        }
        catch (InvalidPathException e) {
            return null;
        }
    }

    public static Map<String, Set<Symbol>> externalModulesSymbols() {
        HashMap<String, Set<Symbol>> globalSymbols = new HashMap<String, Set<Symbol>>();
        globalSymbols.put("flask_mail", new HashSet<ClassSymbolImpl>(Arrays.asList(SymbolUtils.classSymbol("Mail", "flask_mail.Mail", "send", SEND_MESSAGE), SymbolUtils.classSymbol("Connection", "flask_mail.Connection", "send", SEND_MESSAGE))));
        globalSymbols.put("smtplib", new HashSet<ClassSymbolImpl>(Arrays.asList(SymbolUtils.classSymbol("SMTP", "smtplib.SMTP", "sendmail", SEND_MESSAGE, "starttls"), SymbolUtils.classSymbol("SMTP_SSL", "smtplib.SMTP_SSL", "sendmail", SEND_MESSAGE))));
        globalSymbols.put("http.cookies", new HashSet<ClassSymbolImpl>(Collections.singletonList(SymbolUtils.classSymbol("SimpleCookie", "http.cookies.SimpleCookie", new String[0]))));
        globalSymbols.put("django.http", new HashSet<ClassSymbolImpl>(Arrays.asList(SymbolUtils.classSymbol("HttpResponse", "django.http.HttpResponse", SET_COOKIE, SET_SIGNED_COOKIE, "__setitem__"), SymbolUtils.classSymbol("HttpResponseRedirect", "django.http.HttpResponseRedirect", SET_COOKIE, SET_SIGNED_COOKIE), SymbolUtils.classSymbol("HttpResponsePermanentRedirect", "django.http.HttpResponsePermanentRedirect", SET_COOKIE, SET_SIGNED_COOKIE), SymbolUtils.classSymbol("HttpResponseNotModified", "django.http.HttpResponseNotModified", SET_COOKIE, SET_SIGNED_COOKIE), SymbolUtils.classSymbol("HttpResponseNotFound", "django.http.HttpResponseNotFound", SET_COOKIE, SET_SIGNED_COOKIE), SymbolUtils.classSymbol("HttpResponseForbidden", "django.http.HttpResponseForbidden", SET_COOKIE, SET_SIGNED_COOKIE), SymbolUtils.classSymbol("HttpResponseNotAllowed", "django.http.HttpResponseNotAllowed", SET_COOKIE, SET_SIGNED_COOKIE), SymbolUtils.classSymbol("HttpResponseGone", "django.http.HttpResponseGone", SET_COOKIE, SET_SIGNED_COOKIE), SymbolUtils.classSymbol("HttpResponseServerError", "django.http.HttpResponseServerError", SET_COOKIE, SET_SIGNED_COOKIE), SymbolUtils.classSymbol("HttpResponseBadRequest", "django.http.HttpResponseBadRequest", SET_COOKIE, SET_SIGNED_COOKIE))));
        globalSymbols.put("django.http.response", new HashSet<ClassSymbolImpl>(Collections.singleton(SymbolUtils.classSymbol("HttpResponse", "django.http.response.HttpResponse", new String[0]))));
        ClassSymbolImpl flaskResponse = SymbolUtils.classSymbol("Response", "flask.Response", SET_COOKIE);
        FunctionSymbolImpl makeResponse = new FunctionSymbolImpl("make_response", "flask.make_response", false, false, false, Collections.emptyList(), Collections.emptyList());
        makeResponse.setDeclaredReturnType(InferredTypes.runtimeType(flaskResponse));
        FunctionSymbolImpl redirect = new FunctionSymbolImpl("redirect", "flask.redirect", false, false, false, Collections.emptyList(), Collections.emptyList());
        redirect.setDeclaredReturnType(InferredTypes.runtimeType(flaskResponse));
        globalSymbols.put("flask", new HashSet<SymbolImpl>(Arrays.asList(flaskResponse, makeResponse, redirect)));
        globalSymbols.put("werkzeug.datastructures", new HashSet<ClassSymbolImpl>(Collections.singleton(SymbolUtils.classSymbol("Headers", "werkzeug.datastructures.Headers", "set", "setdefault", "__setitem__"))));
        globalSymbols.put("collections", new HashSet<ClassSymbolImpl>(Arrays.asList(SymbolUtils.classSymbol("deque", "collections.deque", EQ), SymbolUtils.classSymbol("UserList", "collections.UserList", EQ), SymbolUtils.classSymbol("UserDict", "collections.UserDict", EQ), SymbolUtils.classSymbol("ChainMap", "collections.ChainMap", EQ), SymbolUtils.classSymbol("Counter", "collections.Counter", EQ), SymbolUtils.classSymbol("OrderedDict", "collections.OrderedDict", EQ), SymbolUtils.classSymbol("defaultdict", "collections.defaultdict", EQ))));
        ClassSymbolImpl ldapObject = SymbolUtils.classSymbol("LDAPObject", "ldap.LDAPObject", "simple_bind", "simple_bind_s", "bind", "bind_s");
        FunctionSymbolImpl initialize = new FunctionSymbolImpl("initialize", "ldap.initialize", false, false, false, Collections.emptyList(), Collections.emptyList());
        initialize.setDeclaredReturnType(InferredTypes.runtimeType(ldapObject));
        globalSymbols.put("ldap", new HashSet<FunctionSymbolImpl>(Collections.singleton(initialize)));
        ClassSymbolImpl sslContextClass = SymbolUtils.classSymbol("Context", "OpenSSL.SSL.Context", SET_VERIFY);
        SymbolImpl sslSubmodule = SymbolUtils.moduleSymbol("SSL", "OpenSSL.SSL", sslContextClass);
        globalSymbols.put("OpenSSL", Collections.singleton(sslSubmodule));
        ClassSymbolImpl csrfProtect = SymbolUtils.classSymbol("CSRFProtect", "flask_wtf.csrf.CSRFProtect", "init_app", "exempt");
        globalSymbols.put("flask_wtf.csrf", Collections.singleton(csrfProtect));
        ClassSymbolImpl modesCBC = SymbolUtils.classSymbol("CBC", "cryptography.hazmat.primitives.ciphers.modes.CBC", new String[0]);
        ClassSymbolImpl modesECB = SymbolUtils.classSymbol("ECB", "cryptography.hazmat.primitives.ciphers.modes.ECB", new String[0]);
        SymbolImpl cryptographyModesSubmodule = SymbolUtils.moduleSymbol("modes", "cryptography.hazmat.primitives.ciphers.modes", modesCBC, modesECB);
        globalSymbols.put("cryptography.hazmat.primitives.ciphers", Collections.singleton(cryptographyModesSubmodule));
        ClassSymbolImpl pkcs1v15 = SymbolUtils.classSymbol("PKCS1v15", "cryptography.hazmat.primitives.asymmetric.padding.PKCS1v15", new String[0]);
        SymbolImpl cryptographyPaddingSubmodule = SymbolUtils.moduleSymbol("padding", "cryptography.hazmat.primitives.asymmetric.padding", pkcs1v15);
        FunctionSymbolImpl generatePrivateKey = new FunctionSymbolImpl("generate_private_key", "cryptography.hazmat.primitives.asymmetric.rsa.generate_private_key", false, false, false, Collections.emptyList(), Collections.emptyList());
        ClassSymbolImpl rsaPrivateKey = SymbolUtils.classSymbol("RSAPrivateKey", "cryptography.hazmat.primitives.asymmetric.rsa.RSAPrivateKey", "decrypt");
        FunctionSymbolImpl publicKey = new FunctionSymbolImpl("public_key", "cryptography.hazmat.primitives.asymmetric.rsa.RSAPrivateKey.public_key", false, false, false, Collections.emptyList(), Collections.emptyList());
        ClassSymbolImpl rsaPublicKey = SymbolUtils.classSymbol("RSAPublicKey", "cryptography.hazmat.primitives.asymmetric.rsa.RSAPublicKey", "encrypt");
        publicKey.setDeclaredReturnType(InferredTypes.runtimeType(rsaPublicKey));
        rsaPrivateKey.addMembers(Collections.singleton(publicKey));
        generatePrivateKey.setDeclaredReturnType(InferredTypes.runtimeType(rsaPrivateKey));
        SymbolImpl cryptographyRsaSubmodule = SymbolUtils.moduleSymbol("rsa", "cryptography.hazmat.primitives.asymmetric.rsa", generatePrivateKey);
        globalSymbols.put("cryptography.hazmat.primitives.asymmetric", new HashSet<SymbolImpl>(Arrays.asList(cryptographyPaddingSubmodule, cryptographyRsaSubmodule)));
        return globalSymbols;
    }

    private static ClassSymbolImpl classSymbol(String name, String fullyQualifiedName, String ... members) {
        ClassSymbolImpl classSymbol = new ClassSymbolImpl(name, fullyQualifiedName);
        classSymbol.addMembers(Arrays.stream(members).map(m -> new SymbolImpl((String)m, fullyQualifiedName + "." + m)).collect(Collectors.toSet()));
        return classSymbol;
    }

    private static SymbolImpl moduleSymbol(String moduleName, String fullyQualifiedName, Symbol ... childSymbols) {
        SymbolImpl m = new SymbolImpl(moduleName, fullyQualifiedName);
        for (Symbol c : childSymbols) {
            m.addChildSymbol(c);
        }
        return m;
    }

    public static boolean isTypeShedFile(PythonFile pythonFile) {
        return pythonFile instanceof TypeShedPythonFile;
    }
}

