/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.ExecStatement;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.Separators;
import org.sonar.python.tree.SimpleStatement;

public class ExecStatementImpl
extends SimpleStatement
implements ExecStatement {
    private final Token execKeyword;
    private final Expression expression;
    private final Token in;
    private final Expression globalsExpression;
    private final Token comma;
    private final Expression localsExpression;
    private final Separators separators;

    public ExecStatementImpl(Token execKeyword, Expression expression, Token in, @Nullable Expression globalsExpression, @Nullable Token comma, @Nullable Expression localsExpression, Separators separators) {
        this.execKeyword = execKeyword;
        this.expression = expression;
        this.in = in;
        this.globalsExpression = globalsExpression;
        this.comma = comma;
        this.localsExpression = localsExpression;
        this.separators = separators;
    }

    public ExecStatementImpl(Token execKeyword, Expression expression, Separators separators) {
        this.execKeyword = execKeyword;
        this.expression = expression;
        this.in = null;
        this.globalsExpression = null;
        this.comma = null;
        this.localsExpression = null;
        this.separators = separators;
    }

    @Override
    public Token execKeyword() {
        return this.execKeyword;
    }

    @Override
    public Expression expression() {
        return this.expression;
    }

    @Override
    public Expression globalsExpression() {
        return this.globalsExpression;
    }

    @Override
    public Expression localsExpression() {
        return this.localsExpression;
    }

    @Override
    @Nullable
    public Token separator() {
        return this.separators.last();
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.EXEC_STMT;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitExecStatement(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(Arrays.asList(this.execKeyword, this.expression, this.in, this.globalsExpression, this.comma, this.localsExpression), this.separators.elements()).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

