/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FormattedExpression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class FormattedExpressionImpl
extends PyTree
implements FormattedExpression {
    private final Expression expression;
    private final Token equalToken;

    public FormattedExpressionImpl(Expression expression, @Nullable Token equalToken) {
        this.expression = expression;
        this.equalToken = equalToken;
    }

    @Override
    public Expression expression() {
        return this.expression;
    }

    @Override
    public Token equalToken() {
        return this.equalToken;
    }

    @Override
    List<Tree> computeChildren() {
        return Stream.of(this.expression, this.equalToken).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitFormattedExpression(this);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.FORMATTED_EXPRESSION;
    }
}

