/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.types;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.symbols.AmbiguousSymbol;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TypeAnnotation;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.AnyType;
import org.sonar.python.types.RuntimeType;
import org.sonar.python.types.TypeShed;
import org.sonar.python.types.UnionType;

public class InferredTypes {
    private static final Map<String, String> ALIASED_ANNOTATIONS = new HashMap<String, String>();
    public static final InferredType INT;
    public static final InferredType FLOAT;
    public static final InferredType COMPLEX;
    public static final InferredType STR;
    public static final InferredType SET;
    public static final InferredType DICT;
    public static final InferredType LIST;
    public static final InferredType TUPLE;
    public static final InferredType NONE;
    public static final InferredType BOOL;
    private static Map<String, Symbol> builtinSymbols;

    private InferredTypes() {
    }

    public static InferredType anyType() {
        return AnyType.ANY;
    }

    private static InferredType runtimeBuiltinType(String fullyQualifiedName) {
        return new RuntimeType(TypeShed.typeShedClass(fullyQualifiedName));
    }

    public static InferredType runtimeType(@Nullable Symbol typeClass) {
        if (typeClass instanceof ClassSymbol) {
            return new RuntimeType((ClassSymbol)typeClass);
        }
        if (typeClass instanceof AmbiguousSymbol) {
            return InferredTypes.union(((AmbiguousSymbol)typeClass).alternatives().stream().map(InferredTypes::runtimeType));
        }
        return InferredTypes.anyType();
    }

    static void setBuiltinSymbols(Map<String, Symbol> builtinSymbols) {
        InferredTypes.builtinSymbols = Collections.unmodifiableMap(builtinSymbols);
    }

    public static InferredType or(InferredType t1, InferredType t2) {
        return UnionType.or(t1, t2);
    }

    public static InferredType union(Stream<InferredType> types) {
        return types.reduce(InferredTypes::or).orElse(InferredTypes.anyType());
    }

    public static InferredType declaredType(TypeAnnotation typeAnnotation) {
        if (builtinSymbols != null) {
            return InferredTypes.declaredType(typeAnnotation.expression(), builtinSymbols);
        }
        return InferredTypes.declaredType(typeAnnotation.expression(), Collections.emptyMap());
    }

    private static InferredType declaredType(Expression expression, Map<String, Symbol> builtinSymbols) {
        if (expression.is(Tree.Kind.NAME) && !((Name)expression).name().equals("Any")) {
            return InferredTypes.runtimeType(((Name)expression).symbol());
        }
        if (expression.is(Tree.Kind.SUBSCRIPTION)) {
            SubscriptionExpression subscription = (SubscriptionExpression)expression;
            return TreeUtils.getSymbolFromTree(subscription.object()).map(symbol -> InferredTypes.genericType(symbol, subscription.subscripts().expressions(), builtinSymbols)).orElse(InferredTypes.anyType());
        }
        return InferredTypes.anyType();
    }

    private static InferredType genericType(Symbol symbol, List<Expression> subscripts, Map<String, Symbol> builtinSymbols) {
        String builtinFqn = ALIASED_ANNOTATIONS.get(symbol.fullyQualifiedName());
        if (builtinFqn == null) {
            if ("typing.Optional".equals(symbol.fullyQualifiedName()) && subscripts.size() == 1) {
                return InferredTypes.optionalDeclaredType(subscripts, builtinSymbols);
            }
            if ("typing.Union".equals(symbol.fullyQualifiedName())) {
                return InferredTypes.unionDeclaredType(subscripts, builtinSymbols);
            }
            return InferredTypes.runtimeType(symbol);
        }
        return InferredTypes.runtimeType(builtinSymbols.get(builtinFqn));
    }

    private static InferredType unionDeclaredType(List<Expression> subscripts, Map<String, Symbol> builtinSymbols) {
        return InferredTypes.union(subscripts.stream().map(s -> InferredTypes.declaredType(s, builtinSymbols)));
    }

    private static InferredType optionalDeclaredType(List<Expression> subscripts, Map<String, Symbol> builtinSymbols) {
        InferredType noneType = InferredTypes.runtimeType(builtinSymbols.get("NoneType"));
        return InferredTypes.or(InferredTypes.declaredType(subscripts.get(0), builtinSymbols), noneType);
    }

    static {
        ALIASED_ANNOTATIONS.put("typing.List", "list");
        ALIASED_ANNOTATIONS.put("typing.Tuple", "tuple");
        ALIASED_ANNOTATIONS.put("typing.Dict", "dict");
        ALIASED_ANNOTATIONS.put("typing.Set", "set");
        ALIASED_ANNOTATIONS.put("typing.FrozenSet", "frozenset");
        ALIASED_ANNOTATIONS.put("typing.Deque", "deque");
        ALIASED_ANNOTATIONS.put("typing.DefaultDict", "defaultdict");
        ALIASED_ANNOTATIONS.put("typing.Type", "type");
        INT = InferredTypes.runtimeBuiltinType("int");
        FLOAT = InferredTypes.runtimeBuiltinType("float");
        COMPLEX = InferredTypes.runtimeBuiltinType("complex");
        STR = InferredTypes.runtimeBuiltinType("str");
        SET = InferredTypes.runtimeBuiltinType("set");
        DICT = InferredTypes.runtimeBuiltinType("dict");
        LIST = InferredTypes.runtimeBuiltinType("list");
        TUPLE = InferredTypes.runtimeBuiltinType("tuple");
        NONE = InferredTypes.runtimeBuiltinType("NoneType");
        BOOL = InferredTypes.runtimeBuiltinType("bool");
    }
}

