/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.types;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.semantic.ClassSymbolImpl;
import org.sonar.python.types.AnyType;
import org.sonar.python.types.UnionType;

class RuntimeType
implements InferredType {
    private final ClassSymbol typeClass;
    private Set<String> typeClassSuperClassesFQN = null;
    private Set<String> typeClassMembersFQN = null;

    RuntimeType(ClassSymbol typeClass) {
        this.typeClass = typeClass;
    }

    @Override
    public boolean isIdentityComparableWith(InferredType other) {
        if (other == AnyType.ANY) {
            return true;
        }
        if (other instanceof UnionType) {
            return other.isIdentityComparableWith(this);
        }
        return this.equals(other);
    }

    @Override
    public boolean canHaveMember(String memberName) {
        if (this.typeClass.hasUnresolvedTypeHierarchy()) {
            return true;
        }
        return this.typeClass.resolveMember(memberName).isPresent();
    }

    @Override
    public Optional<Symbol> resolveMember(String memberName) {
        return this.typeClass.resolveMember(memberName);
    }

    @Override
    public boolean canOnlyBe(String typeName) {
        return typeName.equals(this.typeClass.fullyQualifiedName());
    }

    @Override
    public boolean canBeOrExtend(String typeName) {
        return this.typeClass.canBeOrExtend(typeName);
    }

    @Override
    public boolean isCompatibleWith(InferredType other) {
        if (other instanceof RuntimeType) {
            RuntimeType otherRuntimeType = (RuntimeType)other;
            String otherFullyQualifiedName = otherRuntimeType.typeClass.fullyQualifiedName();
            boolean isDuckTypeCompatible = !otherRuntimeType.typeClass.declaredMembers().isEmpty() && otherRuntimeType.typeClass.declaredMembers().stream().allMatch(m -> this.typeClass.resolveMember(m.name()).isPresent());
            boolean canBeOrExtend = otherFullyQualifiedName == null || this.canBeOrExtend(otherFullyQualifiedName);
            return isDuckTypeCompatible || canBeOrExtend;
        }
        if (other instanceof UnionType) {
            return ((UnionType)other).types().stream().anyMatch(this::isCompatibleWith);
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuntimeType that = (RuntimeType)o;
        return Objects.equals(this.typeClass.fullyQualifiedName(), that.typeClass.fullyQualifiedName()) && Objects.equals(this.typeClassSuperClassesFQN(), that.typeClassSuperClassesFQN()) && Objects.equals(this.typeClassMembersFQN(), that.typeClassMembersFQN());
    }

    private Set<String> typeClassSuperClassesFQN() {
        if (this.typeClassSuperClassesFQN == null) {
            this.typeClassSuperClassesFQN = this.typeClass.superClasses().stream().map(Symbol::fullyQualifiedName).collect(Collectors.toSet());
        }
        return this.typeClassSuperClassesFQN;
    }

    private Set<String> typeClassMembersFQN() {
        if (this.typeClassMembersFQN == null) {
            this.typeClassMembersFQN = this.typeClass.declaredMembers().stream().map(Symbol::fullyQualifiedName).collect(Collectors.toSet());
        }
        return this.typeClassMembersFQN;
    }

    boolean hasUnresolvedHierarchy() {
        return ((ClassSymbolImpl)this.typeClass).hasUnresolvedTypeHierarchy(false);
    }

    public int hashCode() {
        return Objects.hash(this.typeClass.fullyQualifiedName(), this.typeClassSuperClassesFQN(), this.typeClassMembersFQN());
    }

    public String toString() {
        return "RuntimeType(" + this.typeClass.fullyQualifiedName() + ')';
    }
}

