/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.types;

import com.sonar.sslr.api.AstNode;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.TypeAnnotation;
import org.sonar.python.parser.PythonParser;
import org.sonar.python.semantic.AmbiguousSymbolImpl;
import org.sonar.python.semantic.ClassSymbolImpl;
import org.sonar.python.semantic.FunctionSymbolImpl;
import org.sonar.python.semantic.SymbolImpl;
import org.sonar.python.semantic.SymbolTableBuilder;
import org.sonar.python.tree.FunctionDefImpl;
import org.sonar.python.tree.PythonTreeMaker;
import org.sonar.python.types.InferredTypes;
import org.sonar.python.types.TypeShedPythonFile;

public class TypeShed {
    private static final String TYPING = "typing";
    private static final String TYPING_EXTENSIONS = "typing_extensions";
    private static Map<String, Symbol> builtins;
    private static final Map<String, Set<Symbol>> typeShedSymbols;
    private static final Map<String, Set<Symbol>> builtinGlobalSymbols;
    private static final String STDLIB_2AND3 = "typeshed/stdlib/2and3/";
    private static final String STDLIB_2 = "typeshed/stdlib/2/";
    private static final String STDLIB_3 = "typeshed/stdlib/3/";
    private static final String THIRD_PARTY_2AND3 = "typeshed/third_party/2and3/";
    private static final String THIRD_PARTY_2 = "typeshed/third_party/2/";
    private static final String THIRD_PARTY_3 = "typeshed/third_party/3/";

    private TypeShed() {
    }

    public static Map<String, Symbol> builtinSymbols() {
        if (builtins == null) {
            HashMap<String, Symbol> builtins = new HashMap<String, Symbol>();
            builtins.put("NoneType", new ClassSymbolImpl("NoneType", "NoneType"));
            InputStream resource = TypeShed.class.getResourceAsStream("typeshed/stdlib/2and3/builtins.pyi");
            TypeShedPythonFile file = new TypeShedPythonFile(resource, "");
            AstNode astNode = PythonParser.create().parse(file.content());
            FileInput fileInput = new PythonTreeMaker().fileInput(astNode);
            HashMap<String, Set<Symbol>> globalSymbols = new HashMap<String, Set<Symbol>>();
            Set<Symbol> typingModuleSymbols = TypeShed.typingModuleSymbols();
            globalSymbols.put(TYPING, typingModuleSymbols);
            Set<Symbol> typingExtensionsSymbols = TypeShed.typingExtensionsSymbols(Collections.singletonMap(TYPING, typingModuleSymbols));
            globalSymbols.put(TYPING_EXTENSIONS, typingExtensionsSymbols);
            new SymbolTableBuilder("", file, globalSymbols).visitFileInput(fileInput);
            for (Symbol globalVariable : fileInput.globalVariables()) {
                ((SymbolImpl)globalVariable).removeUsages();
                builtins.put(globalVariable.fullyQualifiedName(), globalVariable);
            }
            TypeShed.builtins = Collections.unmodifiableMap(builtins);
            InferredTypes.setBuiltinSymbols(builtins);
            fileInput.accept(new ReturnTypeVisitor());
            builtinGlobalSymbols.put("", new HashSet(builtins.values()));
        }
        return builtins;
    }

    private static void setDeclaredReturnType(Symbol symbol, FunctionDef functionDef) {
        TypeAnnotation returnTypeAnnotation = functionDef.returnTypeAnnotation();
        if (returnTypeAnnotation == null) {
            return;
        }
        if (symbol.is(Symbol.Kind.FUNCTION)) {
            FunctionSymbolImpl functionSymbol2 = (FunctionSymbolImpl)symbol;
            functionSymbol2.setDeclaredReturnType(InferredTypes.declaredType(returnTypeAnnotation));
        } else if (symbol.is(Symbol.Kind.AMBIGUOUS)) {
            Optional.ofNullable(((FunctionDefImpl)functionDef).functionSymbol()).ifPresent(functionSymbol -> TypeShed.setDeclaredReturnType(functionSymbol, functionDef));
        }
    }

    static Set<Symbol> typingModuleSymbols() {
        Map<String, Symbol> typingPython3 = TypeShed.getModuleSymbols(TYPING, STDLIB_3, Collections.emptyMap());
        Map<String, Symbol> typingPython2 = TypeShed.getModuleSymbols(TYPING, STDLIB_2, Collections.emptyMap());
        return TypeShed.commonSymbols(typingPython2, typingPython3);
    }

    private static Set<Symbol> commonSymbols(Map<String, Symbol> symbolsPython2, Map<String, Symbol> symbolsPython3) {
        HashSet<Symbol> commonSymbols = new HashSet<Symbol>();
        symbolsPython3.forEach((fqn, python3Symbol) -> {
            Symbol python2Symbol = (Symbol)symbolsPython2.get(fqn);
            if (python2Symbol == null) {
                commonSymbols.add((Symbol)python3Symbol);
            } else {
                HashSet<Symbol> symbols = new HashSet<Symbol>();
                symbols.add(python2Symbol);
                symbols.add((Symbol)python3Symbol);
                commonSymbols.add(AmbiguousSymbolImpl.create(symbols));
            }
        });
        symbolsPython2.forEach((fqn, python2Symbol) -> {
            if (symbolsPython3.get(fqn) == null) {
                commonSymbols.add((Symbol)python2Symbol);
            }
        });
        return commonSymbols;
    }

    static Set<Symbol> typingExtensionsSymbols(Map<String, Set<Symbol>> typingSymbols) {
        Map<String, Symbol> typingExtensionSymbols = TypeShed.getModuleSymbols(TYPING_EXTENSIONS, THIRD_PARTY_2AND3, typingSymbols);
        return new HashSet<Symbol>(typingExtensionSymbols.values());
    }

    public static Set<Symbol> symbolsForModule(String moduleName) {
        if (!typeShedSymbols.containsKey(moduleName)) {
            Set<Symbol> symbols = TypeShed.searchTypeShedForModule(moduleName);
            typeShedSymbols.put(moduleName, symbols);
            return symbols;
        }
        return typeShedSymbols.get(moduleName);
    }

    public static Symbol symbolWithFQN(String stdLibModuleName, String fullyQualifiedName) {
        Set<Symbol> symbols = TypeShed.symbolsForModule(stdLibModuleName);
        return symbols.stream().filter(s -> fullyQualifiedName.equals(s.fullyQualifiedName())).findFirst().orElse(null);
    }

    private static Set<Symbol> searchTypeShedForModule(String moduleName) {
        if (TypeShed.isDefinedAsPackage(moduleName)) {
            return Collections.emptySet();
        }
        Set<Symbol> standardLibrarySymbols = new HashSet<Symbol>(TypeShed.getModuleSymbols(moduleName, STDLIB_2AND3, builtinGlobalSymbols).values());
        if (standardLibrarySymbols.isEmpty()) {
            standardLibrarySymbols = TypeShed.commonSymbols(TypeShed.getModuleSymbols(moduleName, STDLIB_2, builtinGlobalSymbols), TypeShed.getModuleSymbols(moduleName, STDLIB_3, builtinGlobalSymbols));
        }
        if (!standardLibrarySymbols.isEmpty()) {
            return standardLibrarySymbols;
        }
        HashSet<Symbol> thirdPartySymbols = new HashSet<Symbol>(TypeShed.getModuleSymbols(moduleName, THIRD_PARTY_2AND3, builtinGlobalSymbols).values());
        if (!thirdPartySymbols.isEmpty()) {
            return thirdPartySymbols;
        }
        return TypeShed.commonSymbols(TypeShed.getModuleSymbols(moduleName, THIRD_PARTY_2, builtinGlobalSymbols), TypeShed.getModuleSymbols(moduleName, THIRD_PARTY_3, builtinGlobalSymbols));
    }

    private static Map<String, Symbol> getModuleSymbols(String moduleName, String categoryPath, Map<String, Set<Symbol>> initialSymbols) {
        String resourcePath = categoryPath + moduleName + ".pyi";
        InputStream resource = TypeShed.class.getResourceAsStream(resourcePath);
        if (resource == null) {
            return Collections.emptyMap();
        }
        TypeShedPythonFile file = new TypeShedPythonFile(resource, moduleName);
        AstNode astNode = PythonParser.create().parse(file.content());
        FileInput fileInput = new PythonTreeMaker().fileInput(astNode);
        new SymbolTableBuilder("", file, initialSymbols).visitFileInput(fileInput);
        fileInput.accept(new ReturnTypeVisitor());
        return fileInput.globalVariables().stream().map(symbol -> {
            ((SymbolImpl)symbol).removeUsages();
            return symbol;
        }).filter(s -> s.fullyQualifiedName() != null && s.fullyQualifiedName().startsWith(moduleName)).collect(Collectors.toMap(Symbol::fullyQualifiedName, Function.identity()));
    }

    private static boolean isDefinedAsPackage(String moduleName) {
        return TypeShed.class.getResourceAsStream(STDLIB_2AND3 + moduleName + "/") != null || TypeShed.class.getResourceAsStream(THIRD_PARTY_2AND3 + moduleName + "/") != null || TypeShed.class.getResourceAsStream(STDLIB_2 + moduleName + "/") != null || TypeShed.class.getResourceAsStream(STDLIB_3 + moduleName + "/") != null || TypeShed.class.getResourceAsStream(THIRD_PARTY_2 + moduleName + "/") != null || TypeShed.class.getResourceAsStream(THIRD_PARTY_3 + moduleName + "/") != null;
    }

    public static ClassSymbol typeShedClass(String fullyQualifiedName) {
        Symbol symbol = TypeShed.builtinSymbols().get(fullyQualifiedName);
        if (symbol == null) {
            throw new IllegalArgumentException("No TypeShed symbol found for name: " + fullyQualifiedName);
        }
        if (symbol.kind() != Symbol.Kind.CLASS) {
            throw new IllegalArgumentException("TypeShed symbol " + fullyQualifiedName + " is not a class");
        }
        return (ClassSymbol)symbol;
    }

    static {
        typeShedSymbols = new HashMap<String, Set<Symbol>>();
        builtinGlobalSymbols = new HashMap<String, Set<Symbol>>();
    }

    static class ReturnTypeVisitor
    extends BaseTreeVisitor {
        ReturnTypeVisitor() {
        }

        @Override
        public void visitFunctionDef(FunctionDef functionDef) {
            Optional.ofNullable(functionDef.name().symbol()).ifPresent(symbol -> {
                TypeShed.setDeclaredReturnType(symbol, functionDef);
                ReturnTypeVisitor.setParameterTypes(symbol, functionDef);
            });
            super.visitFunctionDef(functionDef);
        }

        private static void setParameterTypes(Symbol symbol, FunctionDef functionDef) {
            FunctionSymbol funcDefSymbol;
            if (symbol.is(Symbol.Kind.FUNCTION)) {
                FunctionSymbolImpl functionSymbol = (FunctionSymbolImpl)symbol;
                ParameterList parameters = functionDef.parameters();
                if (parameters != null) {
                    functionSymbol.setParametersWithType(parameters);
                }
            } else if (symbol.is(Symbol.Kind.AMBIGUOUS) && (funcDefSymbol = ((FunctionDefImpl)functionDef).functionSymbol()) != null) {
                ReturnTypeVisitor.setParameterTypes(funcDefSymbol, functionDef);
            }
        }
    }
}

