/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.colorizer;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.channel.CodeReader;
import org.sonar.colorizer.HtmlCodeBuilder;
import org.sonar.colorizer.NotThreadSafeTokenizer;

public class RegexpTokenizer
extends NotThreadSafeTokenizer {
    private final String tagBefore;
    private final String tagAfter;
    private final Matcher matcher;
    private final StringBuilder tmpBuilder = new StringBuilder();

    public RegexpTokenizer(String tagBefore, String tagAfter, String regexp) {
        this.tagBefore = tagBefore;
        this.tagAfter = tagAfter;
        this.matcher = Pattern.compile(regexp).matcher("");
    }

    @Override
    public boolean consume(CodeReader code, HtmlCodeBuilder codeBuilder) {
        if (code.popTo(this.matcher, (Appendable)this.tmpBuilder) > 0) {
            codeBuilder.appendWithoutTransforming(this.tagBefore);
            codeBuilder.append(this.tmpBuilder);
            codeBuilder.appendWithoutTransforming(this.tagAfter);
            this.tmpBuilder.delete(0, this.tmpBuilder.length());
            return true;
        }
        return false;
    }

    @Override
    public RegexpTokenizer clone() {
        return new RegexpTokenizer(this.tagBefore, this.tagAfter, this.matcher.pattern().pattern());
    }
}

