/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.impl.BeanUtils;
import org.sqlproc.engine.impl.SqlInputValue;
import org.sqlproc.engine.impl.SqlMetaIdentItem;
import org.sqlproc.engine.impl.SqlMetaLogOperand;
import org.sqlproc.engine.impl.SqlMetaSimple;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.impl.SqlProcessResult;
import org.sqlproc.engine.impl.SqlType;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.impl.type.SqlMetaType;

class SqlMetaIdent
implements SqlMetaSimple,
SqlMetaLogOperand {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SqlInputValue.Case caseConversion;
    private boolean not;
    private List<SqlMetaIdentItem> elements;
    private SqlType sqlType;
    Map<String, String> values = new HashMap<String, String>();

    SqlMetaIdent(SqlInputValue.Case caseConversion) {
        this(caseConversion, false);
    }

    SqlMetaIdent(SqlInputValue.Case caseConversion, boolean not) {
        this(caseConversion, false, new SqlType());
    }

    SqlMetaIdent(SqlInputValue.Case caseConversion, boolean not, SqlType type) {
        this.elements = new ArrayList<SqlMetaIdentItem>();
        this.caseConversion = caseConversion;
        this.not = not;
        this.sqlType = type;
    }

    void addIdent(String name) {
        SqlMetaIdentItem lastItem;
        String[] names = name.split("=");
        int size = this.elements.size();
        SqlMetaIdentItem sqlMetaIdentItem = lastItem = size > 0 ? this.elements.get(size - 1) : null;
        if (lastItem != null) {
            lastItem.setType(SqlMetaIdentItem.Type.REF);
        }
        this.elements.add(new SqlMetaIdentItem(names[0], SqlMetaIdentItem.Type.VAL));
    }

    void addIdent(SqlMetaIdentItem element) {
        this.elements.add(element);
    }

    void setMetaType(String sMetaType) {
        this.sqlType = new SqlType(sMetaType);
    }

    void setMetaType(SqlMetaType metaType) {
        this.sqlType = new SqlType(metaType);
    }

    public void setValues(String value, String value2) {
        int ix = -1;
        if (value2 == null && (ix = value.indexOf(61)) >= 0) {
            value2 = value.substring(ix + 1);
            value = value.substring(0, ix);
        }
        if (value2 == null) {
            this.sqlType.setValue(value);
        } else {
            this.values.put(value, value2);
        }
    }

    SqlType getSqlType() {
        return this.sqlType;
    }

    void setNot(boolean not) {
        this.not = not;
    }

    boolean isNot() {
        return this.not;
    }

    @Override
    public SqlProcessResult process(SqlProcessContext ctx) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> process : dynamicInputValues=" + ctx.dynamicInputValues + ", class=" + (ctx.dynamicInputValues != null ? ctx.dynamicInputValues.getClass() : null) + ", sqlType=" + this.sqlType);
        }
        SqlProcessResult result = new SqlProcessResult();
        boolean first = true;
        Object obj = ctx.dynamicInputValues;
        StringBuilder s = new StringBuilder(this.elements.size() * 32);
        s.append(':');
        int size = this.elements.size();
        int count = 1;
        String sequenceName = this.values.get("seq");
        String attributeName = null;
        Class<?> attributeType = obj != null ? obj.getClass() : null;
        for (SqlMetaIdentItem item : this.elements) {
            attributeName = item.getName();
            if (attributeType != null) {
                Class<?> origAttributeType = attributeType;
                if ((attributeType = BeanUtils.getFieldType(attributeType, attributeName)) == null) {
                    if (SqlProcessContext.isFeature("IGNORE_INPROPER_IN")) {
                        this.logger.error("There's no attribute '" + attributeName + "' for " + origAttributeType);
                    } else {
                        throw new SqlRuntimeException("There's no attribute '" + attributeName + "' for " + origAttributeType);
                    }
                }
            }
            if (count > 1) {
                s.append('_');
            }
            s.append(attributeName);
            if (sequenceName != null && count == size) break;
            if (obj != null) {
                obj = BeanUtils.getProperty(obj, item.getName());
            }
            ++count;
        }
        if (sequenceName != null) {
            String sequence = SqlProcessContext.getFeature(sequenceName);
            if (sequence == null) {
                throw new SqlRuntimeException("Missing sequence " + sequenceName);
            }
            result.add(true);
            SqlInputValue identityInputValue = new SqlInputValue(obj, attributeType, sequence, this.sqlType);
            result.addInputValue(s.substring(1), identityInputValue);
            result.addIdentity(attributeName, identityInputValue);
        } else {
            try {
                result.add(SqlUtils.isEmpty(obj, this.sqlType, ctx.inSqlSetOrInsert));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Input value " + attributeName + ", failed reason" + e.getMessage());
            }
            result.addInputValue(s.substring(1), new SqlInputValue(obj, attributeType, this.caseConversion, this.sqlType));
        }
        result.setSql(s);
        return result;
    }

    @Override
    public boolean processExpression(SqlProcessContext ctx) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> processExpression : dynamicInputValues=" + ctx.dynamicInputValues + ", class=" + (ctx.dynamicInputValues != null ? ctx.dynamicInputValues.getClass() : null) + ", sqlType=" + this.sqlType);
        }
        Object obj = ctx.dynamicInputValues;
        for (SqlMetaIdentItem item : this.elements) {
            if (obj == null) continue;
            obj = BeanUtils.getProperty(obj, item.getName());
        }
        boolean result = SqlUtils.isTrue(obj, this.sqlType);
        return this.not ? !result : result;
    }
}

