/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl.type;

import java.lang.reflect.Method;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.type.Type;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.impl.BeanUtils;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.impl.type.SqlGenericType;

public class SqlByteArrayType
extends SqlGenericType {
    @Override
    public Type getHibernateType() {
        return Hibernate.BINARY;
    }

    @Override
    public Class<?>[] getClassTypes() {
        return new Class[]{byte[].class, Byte[].class};
    }

    @Override
    public String[] getMetaTypes() {
        return new String[]{"BYTEARR", "BYTEARRAY", "BYTES"};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setResult(Object resultInstance, String attributeName, Object resultValue, boolean ingoreError) throws SqlRuntimeException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> setResult " + this.getMetaTypes()[0] + ": resultInstance=" + resultInstance + ", attributeName=" + attributeName + ", resultValue=" + resultValue);
        }
        if (resultValue instanceof byte[]) {
            Method m = BeanUtils.getSetter(resultInstance, attributeName, byte[].class);
            if (m != null) {
                BeanUtils.simpleInvokeMethod(m, resultInstance, resultValue);
                return;
            } else {
                m = BeanUtils.getSetter(resultInstance, attributeName, Byte[].class);
                if (m != null) {
                    BeanUtils.simpleInvokeMethod(m, resultInstance, SqlUtils.toBytes((byte[])resultValue));
                    return;
                } else {
                    if (!ingoreError) throw new SqlRuntimeException("There's no setter for " + attributeName + " in " + resultInstance + ", META type is " + this.getMetaTypes()[0]);
                    this.logger.error("There's no getter for " + attributeName + " in " + resultInstance + ", META type is " + this.getMetaTypes()[0]);
                }
            }
            return;
        } else {
            if (!(resultValue instanceof Byte[])) throw new RuntimeException("Incorrect binary array " + resultValue);
            Method m = BeanUtils.getSetter(resultInstance, attributeName, Byte[].class);
            if (m != null) {
                BeanUtils.simpleInvokeMethod(m, resultInstance, resultValue);
                return;
            } else {
                if (!ingoreError) throw new SqlRuntimeException("There's no setter for " + attributeName + " in " + resultInstance + ", META type is " + this.getMetaTypes()[0]);
                this.logger.error("There's no getter for " + attributeName + " in " + resultInstance + ", META type is " + this.getMetaTypes()[0]);
            }
        }
    }

    @Override
    public void setParameter(Query query, String paramName, Object inputValue, Class<?> inputType, boolean ingoreError) throws SqlRuntimeException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> setParameter " + this.getMetaTypes()[0] + ": paramName=" + paramName + ", inputValue=" + inputValue + ", inputType=" + inputType);
        }
        if (inputValue == null) {
            query.setParameter(paramName, inputValue, (Type)Hibernate.BINARY);
        } else if (inputValue instanceof byte[]) {
            query.setBinary(paramName, (byte[])inputValue);
        } else if (inputValue instanceof Byte[]) {
            query.setBinary(paramName, SqlUtils.toBytes((Byte[])inputValue));
        } else if (ingoreError) {
            this.logger.error("Incorrect binary array " + inputValue + " for " + paramName);
        } else {
            throw new SqlRuntimeException("Incorrect binary array " + inputValue + " for " + paramName);
        }
    }
}

