/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.client2.jsonextract;

import com.dropbox.client2.jsonextract.JsonBase;
import com.dropbox.client2.jsonextract.JsonExtractionException;
import com.dropbox.client2.jsonextract.JsonExtractor;
import com.dropbox.client2.jsonextract.JsonList;
import com.dropbox.client2.jsonextract.JsonMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class JsonThing
extends JsonBase<Object> {
    private static final HashMap<Class, String> TypeNames = new HashMap();

    public JsonThing(Object internal, String path) {
        super(internal, path);
    }

    public JsonThing(Object internal) {
        super(internal, null);
    }

    private static String typeNameForClass(Class<?> c) {
        if (c == null) {
            return "null";
        }
        String name = TypeNames.get(c);
        assert (name != null);
        return name;
    }

    private static String typeNameForObject(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof Number) {
            return "a number";
        }
        if (o instanceof String) {
            return "a string";
        }
        if (o instanceof Boolean) {
            return "a boolean";
        }
        if (o instanceof Map) {
            return "an object";
        }
        if (o instanceof List) {
            return "an array";
        }
        throw new IllegalArgumentException("not a valid org.json.simple type: " + o.getClass().getName());
    }

    private boolean is(Class<?> type) {
        assert (type != null);
        return type.isInstance(this.internal);
    }

    private <T> T expect(Class<T> type) throws JsonExtractionException {
        assert (type != null);
        if (type.isInstance(this.internal)) {
            Object recast = this.internal;
            return (T)recast;
        }
        throw this.error("expecting " + JsonThing.typeNameForClass(type) + ", found " + JsonThing.typeNameForObject(this.internal));
    }

    public void expectNull() throws JsonExtractionException {
        if (this.internal != null) {
            throw this.error("expecting null");
        }
    }

    public boolean isNull() {
        return this.internal == null;
    }

    public JsonMap expectMap() throws JsonExtractionException {
        Map mapInternal = this.expect(Map.class);
        return new JsonMap(mapInternal, this.path);
    }

    public boolean isMap() {
        return this.is(Map.class);
    }

    public JsonList expectList() throws JsonExtractionException {
        List listInternal = this.expect(List.class);
        return new JsonList(listInternal, this.path);
    }

    public boolean isList() {
        return this.is(List.class);
    }

    public Number expectNumber() throws JsonExtractionException {
        return this.expect(Number.class);
    }

    public boolean isNumber() {
        return this.is(Number.class);
    }

    public long expectInt64() throws JsonExtractionException {
        if (this.internal instanceof Number) {
            Number number = (Number)this.internal;
            return number.longValue();
        }
        if (this.internal instanceof String) {
            String string = (String)this.internal;
            try {
                return Long.parseLong(string, 16);
            }
            catch (NumberFormatException ex) {
                throw this.error("couldn't parse string as hex (expecting a 64-bit signed integer value)");
            }
        }
        throw this.error("expecting an integer (or a hex string), found " + JsonThing.typeNameForObject(this.internal));
    }

    public boolean isInt64() {
        try {
            this.expectInt64();
            return true;
        }
        catch (JsonExtractionException ex) {
            return false;
        }
    }

    public String expectString() throws JsonExtractionException {
        return this.expect(String.class);
    }

    public String expectStringOrNull() throws JsonExtractionException {
        if (this.internal == null) {
            return null;
        }
        return this.expect(String.class);
    }

    public boolean isString() {
        return this.is(String.class);
    }

    public boolean expectBoolean() throws JsonExtractionException {
        return this.expect(Boolean.class);
    }

    public boolean isBoolean() {
        return this.is(Boolean.class);
    }

    static String pathConcat(String a, String b) {
        if (a == null) {
            return b;
        }
        return a + "/" + b;
    }

    public JsonExtractionException unexpected() {
        return this.error("unexpected type: " + JsonThing.typeNameForObject(this.internal));
    }

    public <T> T optionalExtract(JsonExtractor<T> extractor) throws JsonExtractionException {
        if (this.isNull()) {
            return null;
        }
        return extractor.extract(this);
    }

    static {
        TypeNames.put(String.class, "a string");
        TypeNames.put(Number.class, "a number");
        TypeNames.put(Boolean.class, "a boolean");
        TypeNames.put(Map.class, "an object");
        TypeNames.put(List.class, "an array");
    }

    public static final class OptionalExtractor<T>
    extends JsonExtractor<T> {
        public final JsonExtractor<T> elementExtractor;

        public OptionalExtractor(JsonExtractor<T> elementExtractor) {
            this.elementExtractor = elementExtractor;
        }

        @Override
        public T extract(JsonThing jt) throws JsonExtractionException {
            return jt.optionalExtract(this.elementExtractor);
        }
    }
}

